<?php

/**
 * Projekt filter form base class.
 *
 * @package    zengardencss
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseProjektFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'                     => new sfWidgetFormFilterInput(),
      'slug'                      => new sfWidgetFormFilterInput(),
      'liczbaczcionek'            => new sfWidgetFormFilterInput(),
      'projekt_has_czcionka_list' => new sfWidgetFormPropelChoice(array('model' => 'Czcionka', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'nazwa'                     => new sfValidatorPass(array('required' => false)),
      'slug'                      => new sfValidatorPass(array('required' => false)),
      'liczbaczcionek'            => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'projekt_has_czcionka_list' => new sfValidatorPropelChoice(array('model' => 'Czcionka', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('projekt_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function addProjektHasCzcionkaListColumnCriteria(Criteria $criteria, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $criteria->addJoin(ProjektHasCzcionkaPeer::PROJEKT_ID, ProjektPeer::PROJEKT_ID);

    $value = array_pop($values);
    $criterion = $criteria->getNewCriterion(ProjektHasCzcionkaPeer::CZCIONKA_ID, $value);

    foreach ($values as $value)
    {
      $criterion->addOr($criteria->getNewCriterion(ProjektHasCzcionkaPeer::CZCIONKA_ID, $value));
    }

    $criteria->add($criterion);
  }

  public function getModelName()
  {
    return 'Projekt';
  }

  public function getFields()
  {
    return array(
      'projekt_id'                => 'Number',
      'nazwa'                     => 'Text',
      'slug'                      => 'Text',
      'liczbaczcionek'            => 'Number',
      'projekt_has_czcionka_list' => 'ManyKey',
    );
  }
}
