<?php

/**
 * Czcionka filter form base class.
 *
 * @package    zengardencss
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseCzcionkaFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'                     => new sfWidgetFormFilterInput(),
      'podglad'                   => new sfWidgetFormFilterInput(),
      'liczbaprojektow'           => new sfWidgetFormFilterInput(),
      'slug'                      => new sfWidgetFormFilterInput(),
      'platforma_id'              => new sfWidgetFormFilterInput(),
      'rodzina_id'                => new sfWidgetFormPropelChoice(array('model' => 'Rodzina', 'add_empty' => true)),
      'projekt_has_czcionka_list' => new sfWidgetFormPropelChoice(array('model' => 'Projekt', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'nazwa'                     => new sfValidatorPass(array('required' => false)),
      'podglad'                   => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'liczbaprojektow'           => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'slug'                      => new sfValidatorPass(array('required' => false)),
      'platforma_id'              => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'rodzina_id'                => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Rodzina', 'column' => 'rodzina_id')),
      'projekt_has_czcionka_list' => new sfValidatorPropelChoice(array('model' => 'Projekt', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('czcionka_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function addProjektHasCzcionkaListColumnCriteria(Criteria $criteria, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $criteria->addJoin(ProjektHasCzcionkaPeer::CZCIONKA_ID, CzcionkaPeer::CZCIONKA_ID);

    $value = array_pop($values);
    $criterion = $criteria->getNewCriterion(ProjektHasCzcionkaPeer::PROJEKT_ID, $value);

    foreach ($values as $value)
    {
      $criterion->addOr($criteria->getNewCriterion(ProjektHasCzcionkaPeer::PROJEKT_ID, $value));
    }

    $criteria->add($criterion);
  }

  public function getModelName()
  {
    return 'Czcionka';
  }

  public function getFields()
  {
    return array(
      'czcionka_id'               => 'Number',
      'nazwa'                     => 'Text',
      'podglad'                   => 'Number',
      'liczbaprojektow'           => 'Number',
      'slug'                      => 'Text',
      'platforma_id'              => 'Number',
      'rodzina_id'                => 'ForeignKey',
      'projekt_has_czcionka_list' => 'ManyKey',
    );
  }
}
