<?php

/**
 * Base class that represents a row from the 'pokoj' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.4.2 on:
 *
 * 12/08/10 18:31:49
 *
 * @package    lib.model.om
 */
abstract class BasePokoj extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        PokojPeer
	 */
	protected static $peer;

	/**
	 * The value for the pokoj_id field.
	 * @var        int
	 */
	protected $pokoj_id;

	/**
	 * The value for the numer field.
	 * @var        string
	 */
	protected $numer;

	/**
	 * The value for the telefon field.
	 * @var        string
	 */
	protected $telefon;

	/**
	 * The value for the slug field.
	 * @var        string
	 */
	protected $slug;

	/**
	 * The value for the sortowanie field.
	 * Note: this column has a database default value of: 999999999
	 * @var        int
	 */
	protected $sortowanie;

	/**
	 * @var        array Pracownik[] Collection to store aggregation of Pracownik objects.
	 */
	protected $collPracowniks;

	/**
	 * @var        Criteria The criteria used to select the current contents of collPracowniks.
	 */
	private $lastPracownikCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	// symfony behavior
	
	const PEER = 'PokojPeer';

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
		$this->sortowanie = 999999999;
	}

	/**
	 * Initializes internal state of BasePokoj object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Get the [pokoj_id] column value.
	 * 
	 * @return     int
	 */
	public function getPokojId()
	{
		return $this->pokoj_id;
	}

	/**
	 * Get the [numer] column value.
	 * 
	 * @return     string
	 */
	public function getNumer()
	{
		return $this->numer;
	}

	/**
	 * Get the [telefon] column value.
	 * 
	 * @return     string
	 */
	public function getTelefon()
	{
		return $this->telefon;
	}

	/**
	 * Get the [slug] column value.
	 * 
	 * @return     string
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Get the [sortowanie] column value.
	 * 
	 * @return     int
	 */
	public function getSortowanie()
	{
		return $this->sortowanie;
	}

	/**
	 * Set the value of [pokoj_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Pokoj The current object (for fluent API support)
	 */
	public function setPokojId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->pokoj_id !== $v) {
			$this->pokoj_id = $v;
			$this->modifiedColumns[] = PokojPeer::POKOJ_ID;
		}

		return $this;
	} // setPokojId()

	/**
	 * Set the value of [numer] column.
	 * 
	 * @param      string $v new value
	 * @return     Pokoj The current object (for fluent API support)
	 */
	public function setNumer($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->numer !== $v) {
			$this->numer = $v;
			$this->modifiedColumns[] = PokojPeer::NUMER;
		}

		return $this;
	} // setNumer()

	/**
	 * Set the value of [telefon] column.
	 * 
	 * @param      string $v new value
	 * @return     Pokoj The current object (for fluent API support)
	 */
	public function setTelefon($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->telefon !== $v) {
			$this->telefon = $v;
			$this->modifiedColumns[] = PokojPeer::TELEFON;
		}

		return $this;
	} // setTelefon()

	/**
	 * Set the value of [slug] column.
	 * 
	 * @param      string $v new value
	 * @return     Pokoj The current object (for fluent API support)
	 */
	public function setSlug($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->slug !== $v) {
			$this->slug = $v;
			$this->modifiedColumns[] = PokojPeer::SLUG;
		}

		return $this;
	} // setSlug()

	/**
	 * Set the value of [sortowanie] column.
	 * 
	 * @param      int $v new value
	 * @return     Pokoj The current object (for fluent API support)
	 */
	public function setSortowanie($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->sortowanie !== $v || $this->isNew()) {
			$this->sortowanie = $v;
			$this->modifiedColumns[] = PokojPeer::SORTOWANIE;
		}

		return $this;
	} // setSortowanie()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			if ($this->sortowanie !== 999999999) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->pokoj_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->numer = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->telefon = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->slug = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->sortowanie = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 5; // 5 = PokojPeer::NUM_COLUMNS - PokojPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Pokoj object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PokojPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = PokojPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->collPracowniks = null;
			$this->lastPracownikCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PokojPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$ret = $this->preDelete($con);
			// symfony_behaviors behavior
			foreach (sfMixer::getCallables('BasePokoj:delete:pre') as $callable)
			{
			  if (call_user_func($callable, $this, $con))
			  {
			    $con->commit();
			
			    return;
			  }
			}

			if ($ret) {
				PokojPeer::doDelete($this, $con);
				$this->postDelete($con);
				// symfony_behaviors behavior
				foreach (sfMixer::getCallables('BasePokoj:delete:post') as $callable)
				{
				  call_user_func($callable, $this, $con);
				}

				$this->setDeleted(true);
				$con->commit();
			} else {
				$con->commit();
			}
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PokojPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		$isInsert = $this->isNew();
		try {
			$ret = $this->preSave($con);
			// symfony_behaviors behavior
			foreach (sfMixer::getCallables('BasePokoj:save:pre') as $callable)
			{
			  if (is_integer($affectedRows = call_user_func($callable, $this, $con)))
			  {
			    $con->commit();
			
			    return $affectedRows;
			  }
			}

			if ($isInsert) {
				$ret = $ret && $this->preInsert($con);
			} else {
				$ret = $ret && $this->preUpdate($con);
			}
			if ($ret) {
				$affectedRows = $this->doSave($con);
				if ($isInsert) {
					$this->postInsert($con);
				} else {
					$this->postUpdate($con);
				}
				$this->postSave($con);
				// symfony_behaviors behavior
				foreach (sfMixer::getCallables('BasePokoj:save:post') as $callable)
				{
				  call_user_func($callable, $this, $con, $affectedRows);
				}

				PokojPeer::addInstanceToPool($this);
			} else {
				$affectedRows = 0;
			}
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			if ($this->isNew() ) {
				$this->modifiedColumns[] = PokojPeer::POKOJ_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = PokojPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setPokojId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += PokojPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collPracowniks !== null) {
				foreach ($this->collPracowniks as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = PokojPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collPracowniks !== null) {
					foreach ($this->collPracowniks as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PokojPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getPokojId();
				break;
			case 1:
				return $this->getNumer();
				break;
			case 2:
				return $this->getTelefon();
				break;
			case 3:
				return $this->getSlug();
				break;
			case 4:
				return $this->getSortowanie();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = PokojPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getPokojId(),
			$keys[1] => $this->getNumer(),
			$keys[2] => $this->getTelefon(),
			$keys[3] => $this->getSlug(),
			$keys[4] => $this->getSortowanie(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PokojPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setPokojId($value);
				break;
			case 1:
				$this->setNumer($value);
				break;
			case 2:
				$this->setTelefon($value);
				break;
			case 3:
				$this->setSlug($value);
				break;
			case 4:
				$this->setSortowanie($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PokojPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setPokojId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setNumer($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setTelefon($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSlug($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSortowanie($arr[$keys[4]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(PokojPeer::DATABASE_NAME);

		if ($this->isColumnModified(PokojPeer::POKOJ_ID)) $criteria->add(PokojPeer::POKOJ_ID, $this->pokoj_id);
		if ($this->isColumnModified(PokojPeer::NUMER)) $criteria->add(PokojPeer::NUMER, $this->numer);
		if ($this->isColumnModified(PokojPeer::TELEFON)) $criteria->add(PokojPeer::TELEFON, $this->telefon);
		if ($this->isColumnModified(PokojPeer::SLUG)) $criteria->add(PokojPeer::SLUG, $this->slug);
		if ($this->isColumnModified(PokojPeer::SORTOWANIE)) $criteria->add(PokojPeer::SORTOWANIE, $this->sortowanie);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(PokojPeer::DATABASE_NAME);

		$criteria->add(PokojPeer::POKOJ_ID, $this->pokoj_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getPokojId();
	}

	/**
	 * Generic method to set the primary key (pokoj_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setPokojId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Pokoj (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setNumer($this->numer);

		$copyObj->setTelefon($this->telefon);

		$copyObj->setSlug($this->slug);

		$copyObj->setSortowanie($this->sortowanie);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getPracowniks() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addPracownik($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setPokojId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Pokoj Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     PokojPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new PokojPeer();
		}
		return self::$peer;
	}

	/**
	 * Clears out the collPracowniks collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addPracowniks()
	 */
	public function clearPracowniks()
	{
		$this->collPracowniks = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collPracowniks collection (array).
	 *
	 * By default this just sets the collPracowniks collection to an empty array (like clearcollPracowniks());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initPracowniks()
	{
		$this->collPracowniks = array();
	}

	/**
	 * Gets an array of Pracownik objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Pokoj has previously been saved, it will retrieve
	 * related Pracowniks from storage. If this Pokoj is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Pracownik[]
	 * @throws     PropelException
	 */
	public function getPracowniks($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PokojPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPracowniks === null) {
			if ($this->isNew()) {
			   $this->collPracowniks = array();
			} else {

				$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

				PracownikPeer::addSelectColumns($criteria);
				$this->collPracowniks = PracownikPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

				PracownikPeer::addSelectColumns($criteria);
				if (!isset($this->lastPracownikCriteria) || !$this->lastPracownikCriteria->equals($criteria)) {
					$this->collPracowniks = PracownikPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPracownikCriteria = $criteria;
		return $this->collPracowniks;
	}

	/**
	 * Returns the number of related Pracownik objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Pracownik objects.
	 * @throws     PropelException
	 */
	public function countPracowniks(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PokojPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collPracowniks === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

				$count = PracownikPeer::doCount($criteria, false, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

				if (!isset($this->lastPracownikCriteria) || !$this->lastPracownikCriteria->equals($criteria)) {
					$count = PracownikPeer::doCount($criteria, false, $con);
				} else {
					$count = count($this->collPracowniks);
				}
			} else {
				$count = count($this->collPracowniks);
			}
		}
		return $count;
	}

	/**
	 * Method called to associate a Pracownik object to this object
	 * through the Pracownik foreign key attribute.
	 *
	 * @param      Pracownik $l Pracownik
	 * @return     void
	 * @throws     PropelException
	 */
	public function addPracownik(Pracownik $l)
	{
		if ($this->collPracowniks === null) {
			$this->initPracowniks();
		}
		if (!in_array($l, $this->collPracowniks, true)) { // only add it if the **same** object is not already associated
			array_push($this->collPracowniks, $l);
			$l->setPokoj($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Pokoj is new, it will return
	 * an empty collection; or if this Pokoj has previously
	 * been saved, it will retrieve related Pracowniks from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Pokoj.
	 */
	public function getPracowniksJoinStanowisko($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PokojPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPracowniks === null) {
			if ($this->isNew()) {
				$this->collPracowniks = array();
			} else {

				$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

				$this->collPracowniks = PracownikPeer::doSelectJoinStanowisko($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

			if (!isset($this->lastPracownikCriteria) || !$this->lastPracownikCriteria->equals($criteria)) {
				$this->collPracowniks = PracownikPeer::doSelectJoinStanowisko($criteria, $con, $join_behavior);
			}
		}
		$this->lastPracownikCriteria = $criteria;

		return $this->collPracowniks;
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Pokoj is new, it will return
	 * an empty collection; or if this Pokoj has previously
	 * been saved, it will retrieve related Pracowniks from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Pokoj.
	 */
	public function getPracowniksJoinKatedra($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PokojPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPracowniks === null) {
			if ($this->isNew()) {
				$this->collPracowniks = array();
			} else {

				$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

				$this->collPracowniks = PracownikPeer::doSelectJoinKatedra($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(PracownikPeer::POKOJ_ID, $this->pokoj_id);

			if (!isset($this->lastPracownikCriteria) || !$this->lastPracownikCriteria->equals($criteria)) {
				$this->collPracowniks = PracownikPeer::doSelectJoinKatedra($criteria, $con, $join_behavior);
			}
		}
		$this->lastPracownikCriteria = $criteria;

		return $this->collPracowniks;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collPracowniks) {
				foreach ((array) $this->collPracowniks as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collPracowniks = null;
	}

	// symfony_behaviors behavior
	
	/**
	 * Calls methods defined via {@link sfMixer}.
	 */
	public function __call($method, $arguments)
	{
	  if (!$callable = sfMixer::getCallable('BasePokoj:'.$method))
	  {
	    throw new sfException(sprintf('Call to undefined method BasePokoj::%s', $method));
	  }
	
	  array_unshift($arguments, $this);
	
	  return call_user_func_array($callable, $arguments);
	}

	/**
	 * Return the string representation of this object
	 *
	 * @return string The value of the 'numer' column
	 */
  public function __toString()
  {
    return (string) $this->getNumer();
  }

} // BasePokoj
