<?php

/**
 * Wydzial form base class.
 *
 * @method Wydzial getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseWydzialForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'wydzial_id' => new sfWidgetFormInputHidden(),
      'nazwa'      => new sfWidgetFormInputText(),
      'skrot'      => new sfWidgetFormInputText(),
      'slug'       => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'wydzial_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getWydzialId()), 'empty_value' => $this->getObject()->getWydzialId(), 'required' => false)),
      'nazwa'      => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'skrot'      => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'slug'       => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Wydzial', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('wydzial[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Wydzial';
  }


}
