<?php

/**
 * Przydzial form base class.
 *
 * @method Przydzial getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePrzydzialForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'przydzial_id'       => new sfWidgetFormInputHidden(),
      'numergrupy'         => new sfWidgetFormInputText(),
      'nazwa_alternatywna' => new sfWidgetFormInputText(),
      'pracownik_id'       => new sfWidgetFormPropelChoice(array('model' => 'Pracownik', 'add_empty' => true)),
      'przedmiot_id'       => new sfWidgetFormPropelChoice(array('model' => 'Przedmiot', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'przydzial_id'       => new sfValidatorChoice(array('choices' => array($this->getObject()->getPrzydzialId()), 'empty_value' => $this->getObject()->getPrzydzialId(), 'required' => false)),
      'numergrupy'         => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'nazwa_alternatywna' => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'pracownik_id'       => new sfValidatorPropelChoice(array('model' => 'Pracownik', 'column' => 'pracownik_id', 'required' => false)),
      'przedmiot_id'       => new sfValidatorPropelChoice(array('model' => 'Przedmiot', 'column' => 'przedmiot_id', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('przydzial[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Przydzial';
  }


}
