<?php

/**
 * Kierunek form base class.
 *
 * @method Kierunek getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseKierunekForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'kierunek_id'      => new sfWidgetFormInputHidden(),
      'nazwa'            => new sfWidgetFormInputText(),
      'skrot'            => new sfWidgetFormInputText(),
      'sortowanie'       => new sfWidgetFormInputText(),
      'wydzial_id'       => new sfWidgetFormPropelChoice(array('model' => 'Wydzial', 'add_empty' => true)),
      'rodzajstudiow_id' => new sfWidgetFormPropelChoice(array('model' => 'Rodzajstudiow', 'add_empty' => true)),
      'slug'             => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'kierunek_id'      => new sfValidatorChoice(array('choices' => array($this->getObject()->getKierunekId()), 'empty_value' => $this->getObject()->getKierunekId(), 'required' => false)),
      'nazwa'            => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'skrot'            => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'sortowanie'       => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'wydzial_id'       => new sfValidatorPropelChoice(array('model' => 'Wydzial', 'column' => 'wydzial_id', 'required' => false)),
      'rodzajstudiow_id' => new sfValidatorPropelChoice(array('model' => 'Rodzajstudiow', 'column' => 'rodzajstudiow_id', 'required' => false)),
      'slug'             => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorAnd(array(
        new sfValidatorPropelUnique(array('model' => 'Kierunek', 'column' => array('slug'))),
        new sfValidatorPropelUnique(array('model' => 'Kierunek', 'column' => array('skrot'))),
      ))
    );

    $this->widgetSchema->setNameFormat('kierunek[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Kierunek';
  }


}
