<?php

/**
 * Katedra form base class.
 *
 * @method Katedra getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseKatedraForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'katedra_id' => new sfWidgetFormInputHidden(),
      'nazwa'      => new sfWidgetFormInputText(),
      'skrot'      => new sfWidgetFormInputText(),
      'wydzial_id' => new sfWidgetFormPropelChoice(array('model' => 'Wydzial', 'add_empty' => true)),
      'slug'       => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'katedra_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getKatedraId()), 'empty_value' => $this->getObject()->getKatedraId(), 'required' => false)),
      'nazwa'      => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'skrot'      => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'wydzial_id' => new sfValidatorPropelChoice(array('model' => 'Wydzial', 'column' => 'wydzial_id', 'required' => false)),
      'slug'       => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Katedra', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('katedra[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Katedra';
  }


}
