<?php

/**
 * Rodzajzajec filter form base class.
 *
 * @package    angaze
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseRodzajzajecFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'          => new sfWidgetFormFilterInput(),
      'skrot'          => new sfWidgetFormFilterInput(),
      'grupy'          => new sfWidgetFormFilterInput(),
      'sortowanie'     => new sfWidgetFormFilterInput(),
      'slug'           => new sfWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
      'nazwa'          => new sfValidatorPass(array('required' => false)),
      'skrot'          => new sfValidatorPass(array('required' => false)),
      'grupy'          => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'sortowanie'     => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'slug'           => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('rodzajzajec_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Rodzajzajec';
  }

  public function getFields()
  {
    return array(
      'rodzajzajec_id' => 'Number',
      'nazwa'          => 'Text',
      'skrot'          => 'Text',
      'grupy'          => 'Number',
      'sortowanie'     => 'Number',
      'slug'           => 'Text',
    );
  }
}
