<?php

/**
 * Przedmiot filter form base class.
 *
 * @package    angaze
 * @subpackage filter
 * @author     Your name here
 */
abstract class BasePrzedmiotFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'              => new sfWidgetFormFilterInput(),
      'skrot'              => new sfWidgetFormFilterInput(),
      'godz'               => new sfWidgetFormFilterInput(),
      'zal'                => new sfWidgetFormFilterInput(),
      'liczbagrup'         => new sfWidgetFormFilterInput(),
      'semestr'            => new sfWidgetFormFilterInput(),
      'rok'                => new sfWidgetFormFilterInput(),
      'odbywa_sie'         => new sfWidgetFormFilterInput(),
      'nazwa_alternatywna' => new sfWidgetFormFilterInput(),
      'zimalato'           => new sfWidgetFormFilterInput(),
      'rodzajzajec_id'     => new sfWidgetFormPropelChoice(array('model' => 'Rodzajzajec', 'add_empty' => true)),
      'kierunek_id'        => new sfWidgetFormPropelChoice(array('model' => 'Kierunek', 'add_empty' => true)),
      'slug'               => new sfWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
      'nazwa'              => new sfValidatorPass(array('required' => false)),
      'skrot'              => new sfValidatorPass(array('required' => false)),
      'godz'               => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'zal'                => new sfValidatorPass(array('required' => false)),
      'liczbagrup'         => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'semestr'            => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'rok'                => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'odbywa_sie'         => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'nazwa_alternatywna' => new sfValidatorPass(array('required' => false)),
      'zimalato'           => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'rodzajzajec_id'     => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Rodzajzajec', 'column' => 'rodzajzajec_id')),
      'kierunek_id'        => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Kierunek', 'column' => 'kierunek_id')),
      'slug'               => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('przedmiot_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Przedmiot';
  }

  public function getFields()
  {
    return array(
      'przedmiot_id'       => 'Number',
      'nazwa'              => 'Text',
      'skrot'              => 'Text',
      'godz'               => 'Number',
      'zal'                => 'Text',
      'liczbagrup'         => 'Number',
      'semestr'            => 'Number',
      'rok'                => 'Number',
      'odbywa_sie'         => 'Number',
      'nazwa_alternatywna' => 'Text',
      'zimalato'           => 'Number',
      'rodzajzajec_id'     => 'ForeignKey',
      'kierunek_id'        => 'ForeignKey',
      'slug'               => 'Text',
    );
  }
}
