<?php

/**
 * Pokoj filter form base class.
 *
 * @package    angaze
 * @subpackage filter
 * @author     Your name here
 */
abstract class BasePokojFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'numer'      => new sfWidgetFormFilterInput(),
      'telefon'    => new sfWidgetFormFilterInput(),
      'slug'       => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'sortowanie' => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'numer'      => new sfValidatorPass(array('required' => false)),
      'telefon'    => new sfValidatorPass(array('required' => false)),
      'slug'       => new sfValidatorPass(array('required' => false)),
      'sortowanie' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
    ));

    $this->widgetSchema->setNameFormat('pokoj_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Pokoj';
  }

  public function getFields()
  {
    return array(
      'pokoj_id'   => 'Number',
      'numer'      => 'Text',
      'telefon'    => 'Text',
      'slug'       => 'Text',
      'sortowanie' => 'Number',
    );
  }
}
