<?php

/**
 * Katedra filter form base class.
 *
 * @package    angaze
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseKatedraFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'      => new sfWidgetFormFilterInput(),
      'skrot'      => new sfWidgetFormFilterInput(),
      'wydzial_id' => new sfWidgetFormPropelChoice(array('model' => 'Wydzial', 'add_empty' => true)),
      'slug'       => new sfWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
      'nazwa'      => new sfValidatorPass(array('required' => false)),
      'skrot'      => new sfValidatorPass(array('required' => false)),
      'wydzial_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Wydzial', 'column' => 'wydzial_id')),
      'slug'       => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('katedra_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Katedra';
  }

  public function getFields()
  {
    return array(
      'katedra_id' => 'Number',
      'nazwa'      => 'Text',
      'skrot'      => 'Text',
      'wydzial_id' => 'ForeignKey',
      'slug'       => 'Text',
    );
  }
}
