<?php

/**
 * katedra actions.
 *
 * @package    angaze
 * @subpackage katedra
 * @author     Your name here
 */
class katedraActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Katedras = KatedraPeer::doSelect(new Criteria());
  }

  public function executeShow(sfWebRequest $request)
  {
    $this->Katedra = KatedraPeer::retrieveBySlug($request->getParameter('slug'));
    $this->forward404Unless($this->Katedra);
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new KatedraForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new KatedraForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Katedra = KatedraPeer::retrieveByPk($request->getParameter('katedra_id')), sprintf('Object Katedra does not exist (%s).', $request->getParameter('katedra_id')));
    $this->form = new KatedraForm($Katedra);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Katedra = KatedraPeer::retrieveByPk($request->getParameter('katedra_id')), sprintf('Object Katedra does not exist (%s).', $request->getParameter('katedra_id')));
    $this->form = new KatedraForm($Katedra);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Katedra = KatedraPeer::retrieveByPk($request->getParameter('katedra_id')), sprintf('Object Katedra does not exist (%s).', $request->getParameter('katedra_id')));
    $Katedra->delete();

    $this->redirect('katedra/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Katedra = $form->save();

      $this->redirect('katedra/edit?katedra_id='.$Katedra->getKatedraId());
    }
  }
}
