<?php


/**
 * Skeleton subclass for performing query and update operations on the 'pracownik' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.4.2 on:
 *
 * 09/27/10 10:49:41
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    lib.model
 */
class PracownikPeer extends BasePracownikPeer {

    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $dane['slug']);
        $tmp = self::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Pracownik();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }

    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        $criteria = clone $criteria;
        $criteria->addAscendingOrderByColumn(StanowiskoPeer::SORTOWANIE);
        $criteria->addAscendingOrderByColumn(self::NAZWISKO);
        $criteria->addAscendingOrderByColumn(self::IMIE);
        $criteria->addJoin(PracownikPeer::STANOWISKO_ID, StanowiskoPeer::STANOWISKO_ID);
        return parent::doSelect($criteria, $con);
    }

    public static function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }


    public static function obciazeniePracownikow()
    {
	    $sql = "

            SELECT
                pracownik.slug,
                pracownik.tytul,
                pracownik.imie,
                pracownik.nazwisko,
                SUM(przedmiot.godz) as sumagodzin,
                stanowisko.pensum as pensum,
                SUM(przedmiot.godz) - stanowisko.pensum as nadgodziny,
                kierunek.rodzajstudiow_id
            FROM
                pracownik as pracownik,
                przedmiot as przedmiot,
                przydzial as przydzial,
                stanowisko as stanowisko,
                kierunek as kierunek
            WHERE
                pracownik.pracownik_id = przydzial.pracownik_id AND
                przedmiot.przedmiot_id = przydzial.przedmiot_id AND
                stanowisko.stanowisko_id = pracownik.stanowisko_id AND
                przedmiot.odbywa_sie = 1 AND
                przedmiot.kierunek_id = kierunek.kierunek_id

            GROUP BY
                pracownik.pracownik_id

            ORDER BY
                sumagodzin DESC

            ";

            $connection = Propel::getConnection();
            $statement = $connection->prepare($sql);
            $statement->execute();
            $wynik = $statement->fetchAll();

            return $wynik;
	}



} // PracownikPeer
