<?php

/**
 * Rodzajzajec form base class.
 *
 * @method Rodzajzajec getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseRodzajzajecForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'rodzajzajec_id' => new sfWidgetFormInputHidden(),
      'nazwa'          => new sfWidgetFormInputText(),
      'skrot'          => new sfWidgetFormInputText(),
      'grupy'          => new sfWidgetFormInputText(),
      'sortowanie'     => new sfWidgetFormInputText(),
      'slug'           => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'rodzajzajec_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getRodzajzajecId()), 'empty_value' => $this->getObject()->getRodzajzajecId(), 'required' => false)),
      'nazwa'          => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'skrot'          => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'grupy'          => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'sortowanie'     => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'slug'           => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Rodzajzajec', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('rodzajzajec[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Rodzajzajec';
  }


}
