<?php

/**
 * Przedmiot form base class.
 *
 * @method Przedmiot getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePrzedmiotForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'przedmiot_id'       => new sfWidgetFormInputHidden(),
      'nazwa'              => new sfWidgetFormInputText(),
      'skrot'              => new sfWidgetFormInputText(),
      'godz'               => new sfWidgetFormInputText(),
      'zal'                => new sfWidgetFormInputText(),
      'liczbagrup'         => new sfWidgetFormInputText(),
      'semestr'            => new sfWidgetFormInputText(),
      'rok'                => new sfWidgetFormInputText(),
      'odbywa_sie'         => new sfWidgetFormInputText(),
      'nazwa_alternatywna' => new sfWidgetFormInputText(),
      'zimalato'           => new sfWidgetFormInputText(),
      'rodzajzajec_id'     => new sfWidgetFormPropelChoice(array('model' => 'Rodzajzajec', 'add_empty' => true)),
      'kierunek_id'        => new sfWidgetFormPropelChoice(array('model' => 'Kierunek', 'add_empty' => true)),
      'slug'               => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'przedmiot_id'       => new sfValidatorChoice(array('choices' => array($this->getObject()->getPrzedmiotId()), 'empty_value' => $this->getObject()->getPrzedmiotId(), 'required' => false)),
      'nazwa'              => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'skrot'              => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'godz'               => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'zal'                => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'liczbagrup'         => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'semestr'            => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'rok'                => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'odbywa_sie'         => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'nazwa_alternatywna' => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'zimalato'           => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'rodzajzajec_id'     => new sfValidatorPropelChoice(array('model' => 'Rodzajzajec', 'column' => 'rodzajzajec_id', 'required' => false)),
      'kierunek_id'        => new sfValidatorPropelChoice(array('model' => 'Kierunek', 'column' => 'kierunek_id', 'required' => false)),
      'slug'               => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Przedmiot', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('przedmiot[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Przedmiot';
  }


}
