<?php

/**
 * Przydzial filter form base class.
 *
 * @package    angaze
 * @subpackage filter
 * @author     Your name here
 */
abstract class BasePrzydzialFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'numergrupy'         => new sfWidgetFormFilterInput(),
      'nazwa_alternatywna' => new sfWidgetFormFilterInput(),
      'pracownik_id'       => new sfWidgetFormPropelChoice(array('model' => 'Pracownik', 'add_empty' => true)),
      'przedmiot_id'       => new sfWidgetFormPropelChoice(array('model' => 'Przedmiot', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'numergrupy'         => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'nazwa_alternatywna' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'pracownik_id'       => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Pracownik', 'column' => 'pracownik_id')),
      'przedmiot_id'       => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Przedmiot', 'column' => 'przedmiot_id')),
    ));

    $this->widgetSchema->setNameFormat('przydzial_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Przydzial';
  }

  public function getFields()
  {
    return array(
      'przydzial_id'       => 'Number',
      'numergrupy'         => 'Number',
      'nazwa_alternatywna' => 'Number',
      'pracownik_id'       => 'ForeignKey',
      'przedmiot_id'       => 'ForeignKey',
    );
  }
}
