<?php

/**
 * pokoj actions.
 *
 * @package    angaze
 * @subpackage pokoj
 * @author     Your name here
 */
class pokojActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Pokojs = PokojPeer::doSelect(new Criteria());
  }

  public function executeShow(sfWebRequest $request)
  {
    $this->Pokoj = PokojPeer::retrieveBySlug($request->getParameter('slug'));
    $this->forward404Unless($this->Pokoj);
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new PokojForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new PokojForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Pokoj = PokojPeer::retrieveByPk($request->getParameter('pokoj_id')), sprintf('Object Pokoj does not exist (%s).', $request->getParameter('pokoj_id')));
    $this->form = new PokojForm($Pokoj);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Pokoj = PokojPeer::retrieveByPk($request->getParameter('pokoj_id')), sprintf('Object Pokoj does not exist (%s).', $request->getParameter('pokoj_id')));
    $this->form = new PokojForm($Pokoj);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Pokoj = PokojPeer::retrieveByPk($request->getParameter('pokoj_id')), sprintf('Object Pokoj does not exist (%s).', $request->getParameter('pokoj_id')));
    $Pokoj->delete();

    $this->redirect('pokoj/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Pokoj = $form->save();

      $this->redirect('pokoj/edit?pokoj_id='.$Pokoj->getPokojId());
    }
  }
}
