<?php

namespace My\SongBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class DefaultController extends Controller
{
    /**
     * @Route("/{slug}.{_format}", name="_show_")
     * @Template()
     */
    public function showAction($slug, $_format)
    {

        $slugs = array();
        $data  = array();

        foreach (glob('../data/*.txt') as $fn) {
            $tmp = file($fn);
            $t = trim($tmp[0]);
            $s = str_replace('.txt', '', basename($fn));

            $data[] = array(
                'title' => $t,
                'slug' => $s
            );

            $slugs[] = $s;
        }

        if (!in_array($slug, $slugs)) {
            throw $this->createNotFoundException('Podana strona nie istnieje!');
        }

        $p = file('../data/' . $slug . '.txt');
        $title = trim($p[0]);
        $p[0] = '';
        $contents = trim(implode('', $p));
//        return array('title' => $title, 'contents' => $contents, 'slug' => $slug, 'data' => $data);
        return compact('title', 'contents', 'slug', 'data');
    }
}
