<?php

namespace My\BackendBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\FixtureInterface;
use My\BackendBundle\Entity\Mountain;
use Doctrine\Common\Persistence\ObjectManager;

class LoadData implements FixtureInterface
{
    function load(ObjectManager $manager)
    {
        $xml = simplexml_load_file('data/crown-of-the-earth.xml');
        foreach ($xml->mountain as $m) {
            $Mountain = new Mountain();
            $Mountain->setName($m->name);
            $Mountain->setContinent($m->continent);
            $Mountain->setHeight($m->height);
            $manager->persist($Mountain);
        }
        $manager->flush();
    }
}