<?php

namespace My\FrontendBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\FixtureInterface;
use My\FrontendBundle\Entity\Novel;
use My\FrontendBundle\Entity\Method;
use My\FrontendBundle\Entity\Detective;
use Doctrine\Common\Persistence\ObjectManager;

class LoadData implements FixtureInterface
{

  function load(ObjectManager $manager)
  {

    $xml = simplexml_load_file('data/novels.xml');
    foreach ($xml->novel as $n) {

      $Detective = $manager
        ->getRepository('MyFrontendBundle:Detective')
        ->findOneByName($n->detective);

      if (!$Detective) {
        $Detective = new Detective();
        $Detective->setName($n->detective);
        $manager->persist($Detective);
        $manager->flush();
      };

      $Novel = new Novel();
      $Novel->setTitle($n->title);
      $Novel->setDetective($Detective);
      $manager->persist($Novel);
      $manager->flush();

      foreach ($n->methods->method as $m) {

        $Method = $manager
          ->getRepository('MyFrontendBundle:Method')
          ->findOneByName($m);

        if (!$Method) {
          $Method = new Method();
          $Method->setName($m);
          $manager->persist($Method);
          $manager->flush();
        };

        $Novel->addMethod($Method);
        $manager->flush();
      }
    }
  }

}
