<?php

namespace My\BackendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\BackendBundle\Entity\Panstwo;
use My\BackendBundle\Form\PanstwoType;

/**
 * Panstwo controller.
 *
 * @Route("/admin/panstwo")
 */
class PanstwoController extends Controller
{
    /**
     * Lists all Panstwo entities.
     *
     * @Route("/", name="admin_panstwo")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyBackendBundle:Panstwo')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Panstwo entity.
     *
     * @Route("/{id}/show", name="admin_panstwo_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyBackendBundle:Panstwo')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Panstwo entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),        );
    }

    /**
     * Displays a form to create a new Panstwo entity.
     *
     * @Route("/new", name="admin_panstwo_new")
     * @Template()
     */
    public function newAction()
    {
        $entity = new Panstwo();
        $form   = $this->createForm(new PanstwoType(), $entity);

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Creates a new Panstwo entity.
     *
     * @Route("/create", name="admin_panstwo_create")
     * @Method("post")
     * @Template("MyBackendBundle:Panstwo:new.html.twig")
     */
    public function createAction()
    {
        $entity  = new Panstwo();
        $request = $this->getRequest();
        $form    = $this->createForm(new PanstwoType(), $entity);
        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('admin_panstwo_show', array('id' => $entity->getId())));
            
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Displays a form to edit an existing Panstwo entity.
     *
     * @Route("/{id}/edit", name="admin_panstwo_edit")
     * @Template()
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyBackendBundle:Panstwo')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Panstwo entity.');
        }

        $editForm = $this->createForm(new PanstwoType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Edits an existing Panstwo entity.
     *
     * @Route("/{id}/update", name="admin_panstwo_update")
     * @Method("post")
     * @Template("MyBackendBundle:Panstwo:edit.html.twig")
     */
    public function updateAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyBackendBundle:Panstwo')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Panstwo entity.');
        }

        $editForm   = $this->createForm(new PanstwoType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        $request = $this->getRequest();

        $editForm->bindRequest($request);

        if ($editForm->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('admin_panstwo_edit', array('id' => $id)));
        }

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Deletes a Panstwo entity.
     *
     * @Route("/{id}/delete", name="admin_panstwo_delete")
     * @Method("post")
     */
    public function deleteAction($id)
    {
        $form = $this->createDeleteForm($id);
        $request = $this->getRequest();

        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $entity = $em->getRepository('MyBackendBundle:Panstwo')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Panstwo entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('admin_panstwo'));
    }

    private function createDeleteForm($id)
    {
        return $this->createFormBuilder(array('id' => $id))
            ->add('id', 'hidden')
            ->getForm()
        ;
    }
}
