<?php

namespace My\FrontendBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * My\FrontendBundle\Entity\Novel
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="My\FrontendBundle\Entity\NovelRepository")
 */
class Novel
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $title
     *
     * @ORM\Column(name="title", type="string", length=255)
     */
    private $title;

    /**
     * @ORM\ManyToOne(targetEntity="Detective", inversedBy="novels")
     */
    protected $detective;

    /**
     * @ORM\ManyToMany(targetEntity="Method", inversedBy="novels")
     */
    private $methods;


    /**
     * @var string $slug
     *
     * @Gedmo\Slug(fields={"title"})
     * @ORM\Column(length=255, unique=true)
     */
    private $slug;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function getTitle()
    {
        return $this->title;
    }
    public function __construct()
    {
        $this->methods = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Set detective
     *
     * @param My\FrontendBundle\Entity\Detective $detective
     */
    public function setDetective(\My\FrontendBundle\Entity\Detective $detective)
    {
        $this->detective = $detective;
    }

    /**
     * Get detective
     *
     * @return My\FrontendBundle\Entity\Detective 
     */
    public function getDetective()
    {
        return $this->detective;
    }

    /**
     * Add methods
     *
     * @param My\FrontendBundle\Entity\Method $methods
     */
    public function addMethod(\My\FrontendBundle\Entity\Method $methods)
    {
        $this->methods[] = $methods;
    }

    /**
     * Get methods
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getMethods()
    {
        return $this->methods;
    }

    /**
     * Set slug
     *
     * @param string $slug
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    /**
     * Get slug
     *
     * @return string 
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function __toString()
    {
        return (string)$this->getTitle();
    }

}