<?php
/*
 *  $Id$
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information, see
 * <http://www.doctrine-project.org>.
 */

namespace Doctrine\DBAL\Schema;

use Doctrine\DBAL\Schema\Visitor\Visitor;

/**
 * Sequence Structure
 *
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @link    www.doctrine-project.org
 * @since   2.0
 * @version $Revision$
 * @author  Benjamin Eberlei <kontakt@beberlei.de>
 */
class Sequence extends AbstractAsset
{
    /**
     * @var int
     */
    protected $_allocationSize = 1;

    /**
     * @var int
     */
    protected $_initialValue = 1;

    /**
     *
     * @param string $name
     * @param int $allocationSize
     * @param int $initialValue
     */
    public function __construct($name, $allocationSize=1, $initialValue=1)
    {
        $this->_setName($name);
        $this->_allocationSize = (is_numeric($allocationSize))?$allocationSize:1;
        $this->_initialValue = (is_numeric($initialValue))?$initialValue:1;
    }

    public function getAllocationSize()
    {
        return $this->_allocationSize;
    }

    public function getInitialValue()
    {
        return $this->_initialValue;
    }
    
    public function setAllocationSize($allocationSize)
    {
        $this->_allocationSize = (is_numeric($allocationSize))?$allocationSize:1;
    }

    public function setInitialValue($initialValue)
    {
        $this->_initialValue = (is_numeric($initialValue))?$initialValue:1;
    }

    /**
     * @param Visitor $visitor
     */
    public function visit(Visitor $visitor)
    {
        $visitor->acceptSequence($this);
    }
}
