<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Panstwo;
use My\FrontendBundle\Form\PanstwoType;

/**
 * Panstwo controller.
 *
 * @Route("/panstwo")
 */
class PanstwoController extends Controller
{
    /**
     * Lists all Panstwo entities.
     *
     * @Route("/", name="panstwo")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyFrontendBundle:Panstwo')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Panstwo entity.
     *
     * @Route("/{id}/show", name="panstwo_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Panstwo')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Panstwo entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),        );
    }

    /**
     * Displays a form to create a new Panstwo entity.
     *
     * @Route("/new", name="panstwo_new")
     * @Template()
     */
    public function newAction()
    {
        $entity = new Panstwo();
        $form   = $this->createForm(new PanstwoType(), $entity);

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Creates a new Panstwo entity.
     *
     * @Route("/create", name="panstwo_create")
     * @Method("post")
     * @Template("MyFrontendBundle:Panstwo:new.html.twig")
     */
    public function createAction()
    {
        $entity  = new Panstwo();
        $request = $this->getRequest();
        $form    = $this->createForm(new PanstwoType(), $entity);
        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('panstwo_show', array('id' => $entity->getId())));
            
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Displays a form to edit an existing Panstwo entity.
     *
     * @Route("/{id}/edit", name="panstwo_edit")
     * @Template()
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Panstwo')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Panstwo entity.');
        }

        $editForm = $this->createForm(new PanstwoType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Edits an existing Panstwo entity.
     *
     * @Route("/{id}/update", name="panstwo_update")
     * @Method("post")
     * @Template("MyFrontendBundle:Panstwo:edit.html.twig")
     */
    public function updateAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Panstwo')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Panstwo entity.');
        }

        $editForm   = $this->createForm(new PanstwoType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        $request = $this->getRequest();

        $editForm->bindRequest($request);

        if ($editForm->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('panstwo_edit', array('id' => $id)));
        }

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Deletes a Panstwo entity.
     *
     * @Route("/{id}/delete", name="panstwo_delete")
     * @Method("post")
     */
    public function deleteAction($id)
    {
        $form = $this->createDeleteForm($id);
        $request = $this->getRequest();

        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $entity = $em->getRepository('MyFrontendBundle:Panstwo')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Panstwo entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('panstwo'));
    }

    private function createDeleteForm($id)
    {
        return $this->createFormBuilder(array('id' => $id))
            ->add('id', 'hidden')
            ->getForm()
        ;
    }
}
