<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Kontynent;
use My\FrontendBundle\Form\KontynentType;

/**
 * Kontynent controller.
 *
 * @Route("/kontynent")
 */
class KontynentController extends Controller
{
    /**
     * Lists all Kontynent entities.
     *
     * @Route("/", name="kontynent")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyFrontendBundle:Kontynent')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Kontynent entity.
     *
     * @Route("/{id}/show", name="kontynent_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Kontynent')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Kontynent entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),        );
    }

    /**
     * Displays a form to create a new Kontynent entity.
     *
     * @Route("/new", name="kontynent_new")
     * @Template()
     */
    public function newAction()
    {
        $entity = new Kontynent();
        $form   = $this->createForm(new KontynentType(), $entity);

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Creates a new Kontynent entity.
     *
     * @Route("/create", name="kontynent_create")
     * @Method("post")
     * @Template("MyFrontendBundle:Kontynent:new.html.twig")
     */
    public function createAction()
    {
        $entity  = new Kontynent();
        $request = $this->getRequest();
        $form    = $this->createForm(new KontynentType(), $entity);
        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('kontynent_show', array('id' => $entity->getId())));
            
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Displays a form to edit an existing Kontynent entity.
     *
     * @Route("/{id}/edit", name="kontynent_edit")
     * @Template()
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Kontynent')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Kontynent entity.');
        }

        $editForm = $this->createForm(new KontynentType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Edits an existing Kontynent entity.
     *
     * @Route("/{id}/update", name="kontynent_update")
     * @Method("post")
     * @Template("MyFrontendBundle:Kontynent:edit.html.twig")
     */
    public function updateAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Kontynent')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Kontynent entity.');
        }

        $editForm   = $this->createForm(new KontynentType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        $request = $this->getRequest();

        $editForm->bindRequest($request);

        if ($editForm->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('kontynent_edit', array('id' => $id)));
        }

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Deletes a Kontynent entity.
     *
     * @Route("/{id}/delete", name="kontynent_delete")
     * @Method("post")
     */
    public function deleteAction($id)
    {
        $form = $this->createDeleteForm($id);
        $request = $this->getRequest();

        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $entity = $em->getRepository('MyFrontendBundle:Kontynent')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Kontynent entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('kontynent'));
    }

    private function createDeleteForm($id)
    {
        return $this->createFormBuilder(array('id' => $id))
            ->add('id', 'hidden')
            ->getForm()
        ;
    }
}
