I18n for your menu labels
=========================

Let's assume you already have a working translation system.

## Create the template

At first, you need to create a template which extends `knp_menu.html.twig`
and adds the Twig `trans` filter. In this example, the template is located
at `src/Acme/MainBundle/Resources/views/Default/knp_menu.html.twig`. It allows
changing the domain and the parameters for the translator through the extras
of the item.

```jinja
{% extends 'knp_menu.html.twig' %}
{% block label %}{{ item.label|trans(item.getExtra('translation_params', {}), item.getExtra('translation_domain', 'messages')) }}{% endblock %}
```

## Include the template

### Alternative A: I18n for all menus

If you want to translate all of your menus, change the default template:

```yaml
# app/config/config.yml
knp_menu:
    twig:
        template: AcmeMainBundle:Default:knp_menu.html.twig
```

### Alternative B: I18n only for certain menus

If you want to translate a certain menu, add the `template` parameter to
its `knp_menu_render` call.

```jinja
{{ knp_menu_render('name_of_your_menu', {'template': 'AcmeMainBundle:Default:knp_menu.html.twig'}) }}
```

That's it.
