<?php

namespace My\FrontendBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * My\FrontendBundle\Entity\Aktor
 *
 * @ORM\Table()
 * @ORM\Entity
 */
class Aktor
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $imie
     *
     * @ORM\Column(name="imie", type="string", length=255)
     */
    private $imie;

    /**
     * @var string $nazwisko
     *
     * @ORM\Column(name="nazwisko", type="string", length=255)
     */
    private $nazwisko;

    /**
     * @ORM\ManyToMany(targetEntity="Film", mappedBy="aktorzy")
     */
    protected $filmy;

    /**
     * @var string $slug
     *
     * @Gedmo\Slug(fields={"imie","nazwisko"})
     * @ORM\Column(length=255, unique=true)
     */
    private $slug;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set imie
     *
     * @param string $imie
     */
    public function setImie($imie)
    {
        $this->imie = $imie;
    }

    /**
     * Get imie
     *
     * @return string 
     */
    public function getImie()
    {
        return $this->imie;
    }

    /**
     * Set nazwisko
     *
     * @param string $nazwisko
     */
    public function setNazwisko($nazwisko)
    {
        $this->nazwisko = $nazwisko;
    }

    /**
     * Get nazwisko
     *
     * @return string 
     */
    public function getNazwisko()
    {
        return $this->nazwisko;
    }

   /**
     * Get imie & nazwisko
     *
     * @return string
     */
    public function __toString()
    {
        return $this->getImie() . ' ' . $this->getNazwisko();
    }

    public function __construct()
    {
        $this->filmy = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add filmy
     *
     * @param My\FrontendBundle\Entity\Film $filmy
     */
    public function addFilm(\My\FrontendBundle\Entity\Film $filmy)
    {
        $this->filmy[] = $filmy;
    }

    /**
     * Get filmy
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getFilmy()
    {
        return $this->filmy;
    }

    /**
     * Set slug
     *
     * @param string $slug
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    /**
     * Get slug
     *
     * @return string 
     */
    public function getSlug()
    {
        return $this->slug;
    }
}