#include <iostream>
#include <string>
#include <vector>
#include <sstream>
#include <algorithm>
#include <memory>
using namespace std;

#include "visitor.hpp"
#include "model.hpp"

struct HtmlVisitor : Visitor
{
	void visit(const Paragraph& p) override
	{
		oss << "<p>" << p.text << "</p>\n";
	}

	void visit(const ListItem& li) override
	{
		oss << "<li>" << li.text << "</li>\n";
	}

	void visit(const List& l) override
	{
		oss << "<ul>\n";
		for_each(l.begin(), l.end(), [&](const ListItem& li)
		{
			// dopuszczalne tylko jeli wiemy, e zmienna li jest typu ListItem
			this->visit(li);

			// gdyby zmienna li bya typu Element, wykonalibymy
			//li.accept(*this);
		});
		oss << "</ul>\n";
	}

	string str() const override
	{
		return oss.str();
	}

private:
	ostringstream oss;
};

struct MarkdownVisitor : Visitor
{
	// instrukcje warunkowe z uyciem dynamic_cast
	void visit(const Element& e)
	{
		if (const Paragraph* p = dynamic_cast<const Paragraph*>(&e))
		{
			visit(*p);
		} else
		{
			// inne przypadki
		}

	}

	void visit(const Paragraph& p) override
	{
		oss << p.text << "\n";
	}
	
	void visit(const BoldParagraph& p) override
	{
		oss << "*" << p.text << "*\n";
	}

	void visit(const ListItem& li) override
	{
		oss << " * " << li.text << "\n";
	}

	void visit(const List& l) override
	{
		oss << "\n";
		for_each(l.begin(), l.end(), [&](const ListItem& li) { this->visit(li); });
		oss << "\n";
	}


	void visit(const Div& div) override
	{
		oss << "<div>\n";
		for (auto e : div)
		{
			//visit(*e);
			e->accept(*this);
		}
		oss << "</div>\n";
	}

	string str() const override
	{
		return oss.str();
	}

private:
	ostringstream oss;
};

// dodanie nowej klasy wymaga cakowitej ponownej kompilacji

int main_(int argc, char* argv[])
{
	BoldParagraph p{ "Oto kilka kolorw" };
	ListItem red{ "czerwony" };
	ListItem green{ "zielony" };
	ListItem blue{ "niebieski" };
	List colors{ red,green,blue };

	// do pojedynczego dysponowania potrzeba jednej informacji: jaki element wywietli w postaci tekstowej
	// do podwjnego dysponowania potrzeba dwch informacji: jaki element wywietli i przy uyciu jakiego renderera

	vector<Element*> document{ &p, &colors };
	cout << "Reprezentacja tekstowa: " << endl;

	MarkdownVisitor v;
	ostringstream oss;
	//for_each(document.begin(), document.end(), [&](const Element* e)
	//{
	//	// v.visit(*e) nie bdzie dziaa :), ale...
	//	e->accept(v);
	//});
	Div div{ &p, &colors };
	div.print_html(oss);
	cout << oss.str() << endl;

	// wszystko bdzie dobrze, dopki nie zechcemy innej reprezentacji

	getchar();
	return 0;
}
