#include <string>
#include <iostream>
#include <memory>
#include <functional>
#include <sstream>
#include "Person.h"
using namespace std;
#include <boost/serialization/serialization.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>

struct Address
{
  string street;
  string city;
  int suite;


  friend ostream& operator<<(ostream& os, const Address& obj)
  {
    return os
      << "ulica: " << obj.street
      << " miasto: " << obj.city
      << " lokal: " << obj.suite;
  }

private:
  friend class boost::serialization::access;

  template<class Ar> void serialize(Ar& ar, const unsigned int version)
  {
    ar & street;
    ar & city;
    ar & suite;
  }
};

struct Contact
{
  string name;
  Address* address = nullptr;

  friend ostream& operator<<(ostream& os, const Contact& obj)
  {
    return os
      << "osoba: " << obj.name
      << " adres: " << *obj.address;
  }

private:
  friend class boost::serialization::access;

  template<class Ar> void serialize(Ar& ar, const unsigned int version)
  {
    ar & name;
    ar & address; // bez *
  }
};

int main_()
{
  Contact jan;
  jan.name = "Jan Domaski";
  jan.address = new Address{ "Paderewskiego 123", "Warszawa", 123 };

  auto clone = [](const Contact& c)
  {
    ostringstream oss;
    boost::archive::text_oarchive oa(oss);
    oa << c;
    string s = oss.str();

    istringstream iss(oss.str());
    boost::archive::text_iarchive ia(iss);
    Contact result;
    ia >> result;
    return result;
  };

  Contact janina = clone(jan);
  janina.name = "Janina Domaska";
  janina.address->street = "Paderewskiego 123B";
  janina.address->suite = 300;

  cout << jan << endl << janina << endl;

  getchar();
  return 0;
}