#include <cmath>

// nie jest to potrzebne dla fabryki
enum class PointType
{
  cartesian,
  polar
};

class Point
{
  /*Point(float a, float b, PointType type = PointType::cartesian)
  {
  if (type == PointType::cartesian)
  {
  x = a; b = y;
  }
  else
  {
  x = a*cos(b);
  y = a*sin(b);
  }
  }*/

  // uyj metody fabrykujcej
  Point(float x, float y) : x(x), y(y) {}

  class PointFactory
  {
    PointFactory() {}
  public:
    static Point NewCartesian(float x, float y)
    {
      return { x,y };
    }
    static Point NewPolar(float r, float theta)
    {
      return{ r*cos(theta), r*sin(theta) };
    }
  };
public:
  float x, y;
  static PointFactory Factory;
};

int main_2()
{
  // nie bdzie dziaao
  // Point p{ 1,2 };

  // niee!
  // Point::PointFactory pf;

  // jeli fabryka jest publiczna, to
  //auto p = Point::PointFactory::NewCartesian(3, 4);

  // tak czy siak mona uy tego
  auto pp = Point::Factory.NewCartesian(2, 3);

  return 0;
}