#pragma once
#include <string>

struct Paragraph;
struct BoldParagraph;
struct ListItem;
struct List;
struct Div;

struct Visitor
{
	virtual ~Visitor() = default;

	virtual void visit(const Paragraph& p) = 0;
	virtual void visit(const BoldParagraph& p) = 0;
	virtual void visit(const ListItem& li) = 0;
	// mamy problem
	virtual void visit(const List& l) = 0;
	virtual void visit(const Div& div) = 0;

	// za kadym razem przy dodawaniu nowego typu trzeba dodawa kolejn funkcj visit

	virtual std::string str() const = 0;
};
