#include <iostream>
#include <string>
#include <map>
#include <vector>
using namespace std;

enum class State
{
  off_hook,
  connecting,
  connected,
  on_hold,
  on_hook
};

inline ostream& operator<<(ostream& os, const State& s)
{
  switch (s)
  {
    case State::off_hook:
      os << "podniesienia suchawki";
      break;
    case State::connecting:
      os << "czenia si";
      break;
    case State::connected:
      os << "nawizanego poczenia";
      break;
    case State::on_hold:
      os << "zawieszenia poczenia";
      break;
    case State::on_hook:
      os << "odoenia suchawki";
      break;
  }
  return os;
}

enum class Trigger
{
  call_dialed,
  hung_up,
  call_connected,
  placed_on_hold,
  taken_off_hold,
  left_message,
  stop_using_phone
};

inline ostream& operator<<(ostream& os, const Trigger& t)
{
  switch (t)
  {
    case Trigger::call_dialed:
      os << "wybierz numer";
      break;
    case Trigger::hung_up:
      os << "przerwij poczenie";
      break;
    case Trigger::call_connected:
      os << "nawi poczenie";
      break;
    case Trigger::placed_on_hold:
      os << "zawie poczenie";
      break;
    case Trigger::taken_off_hold:
      os << "wznw poczenie";
      break;
    case Trigger::left_message:
      os << "zostaw wiadomo";
      break;
    case Trigger::stop_using_phone:
      os << "od suchawk";
      break;
    default: break;
  }
  return os;
}

int main_f(char* argv[])
{
  map<State, vector<pair<Trigger, State>>> rules;

  rules[State::off_hook] = {
    {Trigger::call_dialed, State::connecting},
    {Trigger::stop_using_phone, State::on_hook}
  };

  rules[State::connecting] = {
    {Trigger::hung_up, State::off_hook},
    {Trigger::call_connected, State::connected}
  };

  rules[State::connected] = {
    {Trigger::left_message, State::off_hook},
    {Trigger::hung_up, State::off_hook},
    {Trigger::placed_on_hold, State::on_hold}
  };

  rules[State::on_hold] = {
    {Trigger::taken_off_hold, State::connected},
    {Trigger::hung_up, State::off_hook}
  };

  State currentState{ State::off_hook },
    exitState{ State::on_hook };

  while (true)
  {
    cout << "Telefon jest obecnie w stanie " << currentState << endl;
    select_trigger:
    cout << "Wybierz wyzwalacz:" << "\n";
 
    int i = 0;
    for (auto item : rules[currentState])
    {
      cout << i++ << ". " << item.first << "\n";
    }

    int input;
    cin >> input;
    if (input < 0 || (input+1) > rules[currentState].size())
    {
      cout << "Niepoprawna opcja. Sprbuj jeszcze raz." << "\n";
      goto select_trigger;
    }

    currentState = rules[currentState][input].second;
    if (currentState == exitState) break;
  }

  cout << "Zakoczylimy uywanie telefonu." << "\n";

  getchar();
  getchar();
  return 0;
}
