#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <mutex>
class Foo;
using namespace std;

// wskanik do funkcji

// wzorzec obserwatora w bibliotece quantlib

// zmiany w kolekcji a zmiany w jej skadowych

// boost::signal
// powiadomienie o zmianie waciwoci
// rxcpp

recursive_mutex mtx;
// ale i tak moe doj do zakleszczenia

struct Listener
{
  virtual void fooChanged(Foo* foo); // nie const
  virtual ~Listener() = default;
};


class Foo
{
  string s;
  vector<Listener*> listeners; // set<>?
  // Uycie kontenera list<> zamiast wektora pozwoli dodatkowo usuwa elementy podczas iterowania
public:

  virtual string GetS() const
  {
    return s;
  }

  virtual void SetS(const string cs)
  {
    // czy tu te naoy blokad?
    if (s != cs)
    {
      s = cs;
      notifyListeners();
    }
  }

  void addListener(Listener* l)
  {
    listeners.push_back(l);

    // dodawanie elementw moe spowodowa realokacj wektora, wic rekurencyjne dodawanie moe si nie powie
  }

  bool removeListener(Listener* l)
  {
    // nic nie usuwa
    //remove(listeners.begin(), listeners.end(), l);



    listeners.erase(
      remove(listeners.begin(), listeners.end(), l),
      listeners.end()
    );

    // alternatywnie wyszukaj i usu
    // to polecenie po prostu usuwa pierwsze wystpienie
    listeners.erase(
      find(listeners.begin(), listeners.end(), l)
    );

    // co si jednak stanie, jeli lista NIE zawiera elementu?
    // wystpi awaria, poniewa funkcja find() zwrci end() :(


    auto it = find(listeners.begin(), listeners.end(), l);
    if (it != listeners.end())
    {
      listeners.erase(it);

      // return true?
    }
    // return false

    // czy mona te rozpocz uyciem rbegin()/rend()
    // nie, funkcja erase() nie przyjmuje typu reverse_iterator

    // czyj Alicj usuwamy? czy powinnimy
    // zwraca memento?

    // rzecz w tym, e to wszystko badziewie pod wzgldem uporzdkowania i podobnych spraw

    // a moe NIE usuwa, ale po prostu nadawa puste wartoci
    for (auto it = listeners.begin(); it != listeners.end(); ++it)
    {
      if (*it == l)
      {
        *it = nullptr; // tylko pierwszy
        // ale moemy obsuy tylko usuwanie samych siebie
        // a nie innych odbiornikw
        return true;
      }
    }

    // a swoj drog, puste odbiorniki zostan unicestwione! moe dokona sprawdzenia?

    return false;
  }
private:
  void notifyListeners()
  {
    lock_guard<recursive_mutex> lg(mtx); // nierekurencyjna

    if (listeners.empty()) return;

    // w tym miejscu niejawna inkrementacja powodujca bd przy rekurencyjnym
    // indeksowaniu tablicy?
    int size = listeners.size();
    for (int i = 0; i < size; ++i)
      if (listeners[i])
        listeners[i]->fooChanged(this); // niebezpieczne
    // usu wszystkie wartoci puste
    listeners.erase(
      remove(listeners.begin(), listeners.end(), nullptr),
      listeners.end()
    );

    // lepsza wersja zaczyna si od 31:12
  }
};

void Listener::fooChanged(Foo* foo)
{
  cout << "Nastpia zmiana foo na " << foo << "\n";
}

struct ScopeListener : Listener
{
  Foo& foo;

  explicit ScopeListener(Foo& foo)
    : foo(foo)
  {
    startListening();
  }

  ~ScopeListener()
  {
    stopListening();
  }

  void startListening() { foo.addListener(this); }
  void stopListening() { foo.removeListener(this); }


  void fooChanged(Foo* foo) override;
};

void ScopeListener::fooChanged(Foo* foo)
{
  cout << foo->GetS();
  this->stopListening();
}

void cppnow_talk()
{
  // Alicja i Bob - odbiorniki s uporzdkowane (priorytet?)

  // dodaj ten sam odbiornik dwa razy - czy to powinien by zbir?
  // jeli usun jeden, usun oba
  // lokalnie kod to obsuy, ale
  // skd bd wiedzia, czy dany element ju istnieje
  // trzeba skorzysta z usage_count albo set<>

  Foo foo;
  ScopeListener sl(foo);

  foo.SetS("abc"); // spowoduje bd
                   // usuwanie odbiornika wewntrz odbiornika
                   // zmienianie iterowanej kolekcji!

  // a wtedy obserwator bdzie mia wskanik do innego obserwatora
}

int main__()
{
  cppnow_talk();

  getchar();
  return 0;
}
