#pragma once
#include <iostream>
#include <vector>
#include <memory>

struct GraphicObject
{
  virtual void draw() = 0;
};

struct Circle : GraphicObject
{
  void draw() override
  {
    std::cout << "Okrg" << std::endl;
  }
};

struct Group : GraphicObject
{
  std::string name;


  explicit Group(const std::string& name)
    : name{name}
  {
  }

  void draw() override
  {
    std::cout << "Grupa " << name.c_str() << " zawiera:" << std::endl;
    for (auto&& o : objects)
      o->draw();
  }

  std::vector<GraphicObject*> objects;
};

inline void graphics()
{
  Group root("gwna");
  Circle c1, c2;
  root.objects.push_back(&c1);

  Group subgroup("podrzdna");
  subgroup.objects.push_back(&c2);

  root.objects.push_back(&subgroup);

  root.draw();
}