#include <string>
#include <iostream>
#include <memory>
#include <functional>
#include <sstream>
#include "Person.h"
using namespace std;
#include <boost/serialization/serialization.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>

struct Address
{
  string street;
  string city;
  int suite;

  Address() : street(nullptr), city(nullptr)
  {} // wymagany do serializacji

  Address(const string& street, const string& city, const int suite)
    : street{street},
      city{city},
      suite{suite}
  {
  }

  /*Address(const Address& other)
    : street{other.street},
      city{other.city},
      suite{other.suite}
  {
  }*/

  friend ostream& operator<<(ostream& os, const Address& obj)
  {
    return os
      << "ulica: " << obj.street
      << " miasto: " << obj.city
      << " lokal: " << obj.suite;
  }

  template <class archive>
  void serialize(archive& ar, const unsigned version)
  {
	ar& street;
	ar& city;
	ar& suite;
  }
};


struct Contact
{
  string name;
  Address* address;

  Contact& operator=(const Contact& other)
  {
    if (this == &other)
      return *this;
    name = other.name;
    address = other.address;
    return *this;
  }

  Contact() : name(nullptr), address(nullptr)
  {} // wymagany do serializacji

  Contact(string name, Address* address)
    : name{name}, address{address}
  {
    //this->address = new Address{ *address };
  }

  Contact(const Contact& other)
    : name{other.name}
    //, address{ new Address{*other.address} }
  {
    address = new Address(
      other.address->street, 
      other.address->city, 
      other.address->suite
    );
  }


private:
  friend class boost::serialization::access;

  template <class archive>
  void save(archive& ar, const unsigned version) const
  {
    ar << name;
    ar << address;
  }

  template <class archive>
  void load(archive& ar, const unsigned version)
  {
    ar >> name;
    ar >> address;
  }

  BOOST_SERIALIZATION_SPLIT_MEMBER()

public:
  ~Contact()
  {
    delete address;
  }


  friend ostream& operator<<(ostream& os, const Contact& obj)
  {
    return os
      << "osoba: " << obj.name
      << " pracuje pod adresem " << *obj.address; // zauwa, e jest tu gwiazdka
  }
};

struct EmployeeFactory
{
  static Contact main;
  static Contact aux;

  static unique_ptr<Contact> NewMainOfficeEmployee(string name, int suite)
  {
    //static Contact p{ "", new Address{ "Paderewskiego 123", "Warszawa", 0 } };
    return NewEmployee(name, suite, main);
  }

  static unique_ptr<Contact> NewAuxOfficeEmployee(string name, int suite)
  {
    return NewEmployee(name, suite, aux);
  }

private:
  static unique_ptr<Contact> NewEmployee(string name, int suite, Contact& proto)
  {
    auto result = make_unique<Contact>(proto);
    result->name = name;
    result->address->suite = suite;
    return result;
  }
};

//Contact EmployeeFactory::main{ "", new Address{ "Paderewskiego 123", "Warszawa", 0 } };
//Contact EmployeeFactory::aux{ "", new Address{ "Paderewskiego 123B", "Warszawa", 0 } };

int main_3423()
{
  // to uciliwe
  // Contact jan{ "Jan Domaski", new Address{"Paderewskiego 123", "Warszawa"} };
  // Contact janina{ "Janina Domaska", new Address{"Paderewskiego 123", "Warszawa"} };

  auto addr = new Address{ "Paderewskiego 123", "Warszawa", 0 /* ? */ };

  //Contact jan{ "Jan Domaski", addr };
  //jan.address->suite = 123;
  //Contact janina{ "Janina Domaska", addr };
  //janina.address->suite = 124;

  //Contact janina2{ janina }; // kopia pobiena
  //janina2.address->suite = 555;

  

  //
  //std::cout << janina2 << std::endl;

  // gdy tylko potrzebny bdzie adres, wykonaj kopi
  /*Contact jan{ "Jan Domaski", new Address{*addr} };
  jan.address->suite = 123;

  Contact janina{ "Janina Domaska", new Address{*addr} };
  janina.address->suite = 125;

  cout << jan << "\n" << janina << endl;*/

  // duo lepiej. wypiszmy pracownikw
  //Contact employee{ "Nieznany", new Address{"Radosna 628", "Wesoa", 0} };

  //// moemy uy tego prototypu do stworzenia obiektw jan i janina
  //Contact jan{ employee };
  //jan.name = "Jan Domaski";
  //jan.address->suite = 123;

  //Contact janina{ employee };
  //janina.name = "Janina Domaska";
  //janina.address->suite = 125;

  //cout << jan << "\n" << janina << "\n";

  //delete addr;

  // 4. Serializacja przy uyciu biblioteki Boost

  auto clone = [](const Contact& c)
  {
    // 1. Zserializuj kontakt
    ostringstream oss;
    boost::archive::text_oarchive oa(oss);
    oa << c;
    string s = oss.str();

    // 2. Zdeserializuj kontakt
    istringstream iss(oss.str());
    boost::archive::text_iarchive ia(iss);
    Contact result;
    ia >> result;
    return result;
  };
  
  // contact jan = ...
  // contact janina = clone(jan)

  //auto jan = EmployeeFactory::NewAuxOfficeEmployee("Jan Domaski", 123);
  //auto janina = EmployeeFactory::NewMainOfficeEmployee("Janina Domaska", 125);

  //cout << *jan << "\n" << *janina << "\n"; // zwr uwag, e s tu gwiazdki

  delete addr;

  getchar();
  return 0;
}