#include <iostream>
#include <string>
using namespace std;

struct Log
{
  virtual void LogInfo(const string& message) const = 0;
};

struct ConsoleLog : Log
{
  void LogInfo(const string& message) const override
  {
    cout << message << endl;
  }
};

template <typename LogType>
struct PaymentProcessing
{
  static_assert(is_base_of<Log, LogType>::value, "Klasa LogType musi by pochodn typu Log");

  LogType log;

  // alternatywnie konstruktor

  void Process()
  {
    log.LogMessage("Przetwarzanie patnoci...");
  }
};

int main()
{
  struct NullLog : Log
  {
    void LogInfo(const string& message) const override
    {
    }
  };

  PaymentProcessing<NullLog> pp;
  
  getchar();
  return 0;
}
