// Obiekty w programie powinny by wymienialne na instancje ich podtypw
// bez wpywu na poprawno programu

#include <iostream>

class Rectangle
{
protected:
  int width, height;
public:
  Rectangle(const int width, const int height)
    : width{width}, height{height} { }

  int get_width() const { return width; }
  virtual void set_width(const int width) { this->width = width; }
  int get_height() const { return height; }
  virtual void set_height(const int height) { this->height = height; }

  int area() const { return width * height; }
};

class Square : public Rectangle
{
public:
  Square(int size): Rectangle(size,size) {}
  void set_width(const int width) override {
    this->width = height = width;
  }
  void set_height(const int height) override {
    this->height = width = height;
  }
};

struct RectangleFactory
{
  static Rectangle create_rectangle(int w, int h);
  static Rectangle create_square(int size);
};

void process(Rectangle& r)
{
  int w = r.get_width();
  r.set_height(10);

  std::cout << "Oczekiwane pole powierzchni = " << (w * 10)
    << ", uzyskano " << r.area() << std::endl;
}

int main342342()
{
  Rectangle r{ 3, 4 };
  process(r);

  Square sq{ 5 };
  process(sq);

  getchar();
  return 0;
}