#pragma once
#include <memory>
#include <map>
#include <string>
using namespace std;

struct HotDrink
{
  virtual ~HotDrink() = default;

  virtual void prepare(int volume) = 0;
};

struct Tea : HotDrink
{

  void prepare(int volume) override
  {
    cout << "We torebk herbaty, zagotuj wod, zalej " << volume << " ml, dodaj czstk cytryny." << endl;
  }
};

struct Coffee : HotDrink
{
  void prepare(int volume) override
  {
    cout << "Zmiel ziarna, zagotuj wod, zalej " << volume << " ml, dodaj mietanki, smacznego!" << endl;
  }
};