#include "Headers.hpp"

struct AddressPrinter
{
  void operator()(const string& house_name) const {
    cout << "Dom o nazwie " << house_name << "\n";
  }

  void operator()(const int house_number) const {
    cout << "Dom numer " << house_number << "\n";
  }
};

int main(int ac, char* av[])
{
  variant<string, int> house;
  //house = "Montefiore Castle";
  house = 221;

  AddressPrinter ap;
  std::visit(ap, house);

  // co jeli chcesz utworzy wizytatora na miejscu?
  std::visit([](auto& arg) {
    using T = decay_t<decltype(arg)>;

    if constexpr (is_same_v<T, string>)
    {
      cout << "Dom o nazwie " << arg.c_str() << "\n";
    }
    else
    {
      cout << "Dom numer " << arg << "\n";
    }
  }, house);

  return 0;
}