#include <iostream>
#include <string>
#include <vector>
using namespace std;

// zaplecze
#include <boost/msm/back/state_machine.hpp>

//fronton
#include <boost/msm/front/state_machine_def.hpp>
#include <boost/msm/front/functor_row.hpp>

namespace msm = boost::msm;
namespace mpl = boost::mpl;
using namespace msm::front;

vector<string> state_names{
  "podniesienia suchawki"s,
  "czenia si"s,
  "nawizanego poczenia"s,
  "zawieszenia poczenia"s,
  "zniszczenia"s
};

// tranzycje/zdarzenia
struct CallDialed {};
struct HungUp {};
struct CallConnected {};
struct PlacedOnHold {};
struct TakenOffHold {};
struct LeftMessage {};
struct PhoneThrownIntoWall {};

struct PhoneStateMachine : state_machine_def<PhoneStateMachine>
{
  bool angry{ true }; // na pocztku warto false

  struct OffHook : state<> {};
  struct Connecting : state<>
  {
    template <class Event, class FSM>
    void on_entry(Event const& evt, FSM&)
    {
      cout << "czymy si..." << endl;
    }
    // rwnie on_exit
  };
  struct Connected : state<> {};
  struct OnHold : state<> {};
  struct PhoneDestroyed : state<> {};

  struct PhoneBeingDestroyed
  {
    template <class EVT, class FSM, class SourceState, class TargetState>
    void operator()(EVT const&, FSM&, SourceState&, TargetState&)
    {
      cout << "Telefon amie si na wiele czci" << endl;
    }
  };
  
  struct CanDestroyPhone
  {
    template <class EVT, class FSM, class SourceState, class TargetState>
    bool operator()(EVT const&, FSM& fsm, SourceState&, TargetState&)
    {
      return fsm.angry;
    }
  };

  // stan rdowy, zdarzenie, stan docelowy, akcja, stranik
  struct transition_table : mpl::vector <
    Row<OffHook, CallDialed, Connecting>,
    Row<Connecting, CallConnected, Connected>,
    Row<Connected, PlacedOnHold, OnHold>,
    Row<OnHold, PhoneThrownIntoWall, PhoneDestroyed, 
        PhoneBeingDestroyed, CanDestroyPhone>
  > {};

  // stan pocztkowy
  typedef OffHook initial_state;

  // co bdzie, jeli nigdzie nie da przej
  template <class FSM, class Event>
  void no_transition(Event const& e, FSM&, int state)
  {
    cout << "Brak moliwoci przejcia ze stanu " << state_names[state]
      << " przy zdarzeniu " << typeid(e).name() << endl;
  }
};



int main()
{
  msm::back::state_machine<PhoneStateMachine> phone;

  auto info = [&]()
  {
    auto i = phone.current_state()[0];
    cout << "Telefon jest obecnie w stanie " <<
      state_names[i] << "\n";
  };

  info();
  phone.process_event(CallDialed{});
  info();
  phone.process_event(CallConnected{});
  info();
  phone.process_event(PlacedOnHold{});
  info();
  phone.process_event(PhoneThrownIntoWall{});
  info();

  // sprbuj tu wywoa process_event
  phone.process_event(CallDialed{});

  cout << "Zakoczylimy uywanie telefonu." << "\n";

  getchar();
  return 0;
}
