#include "Headers.hpp"
#include "Observer.hpp"
#include "Observable.hpp"
#include "SaferObservable.hpp"

class Person : public SaferObservable<Person>
{
  int age;
public:
  Person(int age) : age(age) {}

  int get_age() const
  {
    return age;
  }

  // brak zalenoci
//  void set_age(int age)
//  {
//    if (this->age == age) return;
//    this->age = age;
//    notify(*this, "age");
//  }

  void set_age(int age)
  {
    if (this->age == age) return;

    auto old_can_vote = get_can_vote();
    this->age = age;
    notify(*this, "age");

    // sprawd, czy zmienio si uprawnienie do gosowania
    if (old_can_vote != get_can_vote())
      notify(*this, "can_vote");
  }

  bool get_can_vote() const
  {
    return age >= 18;
  }
};

// moemy zdefiniowa odbiornik dla obiektw Person
struct PersonListener
{
  virtual void person_changed(Person& p,
    const string property_name) = 0;
}; // zmiany mog wystpi w innych obiektach, wic


struct ConsolePersonObserver
  : public Observer<Person> // , Observer<Creature>
{
  void field_changed(Person &source, const string &field_name) override
  {
    cout << "Pole " << field_name << " obiektu Person ma teraz warto ";
    if (field_name == "age") cout << source.get_age();
    if (field_name == "can_vote") cout << boolalpha << source.get_can_vote();
    cout << ".\n";
  }
};

// monitoruje osob, a osignie wiek uprawniajcy do prowadzenia pojazdu,
// a wtedy przestaje j monitorowa
struct TrafficAdministration : Observer<Person>
{
  void field_changed(Person &source, const std::string &field_name) override
  {
    if (field_name == "age")
    {
      if (source.get_age() < 18)
        cout << "Hej tam, masz zbyt mao lat, by prowadzi!\n";
      else
      {
        // zaprzestajemy kontroli
        cout << "aha, ok, ju nas to nie obchodzi!\n";
        source.unsubscribe(*this);
      }
    }
  }
};

// obiekty obserwowalne z uyciem biblioteki Boost.Signals2
template <typename T> struct Observable2
{
  signal<void(T&, const string&)> field_changed;
};

class Person2 : public Observable2<Person2>
{
  int age;
public:
  int get_age() const
  {
    return age;
  }

  void set_age(int age)
  {
    if (this->age == age) return;
    this->age = age;
    field_changed(*this, "age");
  }
};

int main(int ac, char* av[])
{
  // obserwator
  Person person{10};
  ConsolePersonObserver cpo;
  person.subscribe(cpo);

  person.set_age(11);
  person.set_age(12);

  //person.unsubscribe(&cpo);
  person.set_age(13);

  // obserwator sygnaw z biblioteki boost
  Person2 p2;
  auto conn = p2.field_changed.connect([](Person2& p, const string& field_name)
  {
    cout << "Pole " << field_name << " ulego zmianie";
  });
  p2.set_age(20);
  conn.disconnect();

  // problemy z zalenociami
  cout << " Osiganie dojrzaoci...\n";
  person.set_age(20);

  // bezpieczestwo wtkowe i wielobieno
  person.unsubscribe(cpo);
  TrafficAdministration ta;
  person.subscribe(ta);

  person.set_age(17);

  try
  {
    person.set_age(18);
    // notify() --> field_changed() --> ubsubscribe()
  }
  catch (const std::exception& e)
  {
    cout << "Ups, " << e.what() << "\n";
  }

  return 0;
}