#include <iostream>
#include <string>
#include <vector>
#include <memory>
#include <experimental/coroutine>
#include <experimental/generator>
using namespace std;

#include "recursive_generator.h"

template <typename T> struct BinaryTree;

// do zrobienia: zrefaktoryzuj kod tak, by nie odnosi si do caego drzewa, ale do rodzica
template <typename T> struct Node
{
  T value = T();
  Node<T> *left = nullptr;
  Node<T> *right = nullptr;
  Node<T> *parent = nullptr;
  BinaryTree<T>* tree = nullptr;

  explicit Node(const T& value)
    : value(value)
  {
  }

  Node(const T& value, Node<T>* const left, Node<T>* const right)
    : value(value),
      left(left),
      right(right)
  {
    this->left->tree = this->right->tree = tree;
    this->left->parent = this->right->parent = this;
  }

  void set_tree(BinaryTree<T>* t)
  {
    tree = t;
    if (left) left->set_tree(t);
    if (right) right->set_tree(t);
  }

  ~Node()
  {
    if (left) delete left;
    if (right) delete right;
  }
};

template <typename T> struct BinaryTree
{
  Node<T>* root = nullptr;

  explicit BinaryTree(Node<T>* const root)
    : root{ root }, pre_order{ *this }
  {
    root->set_tree(this);
  }

  ~BinaryTree() { if (root) delete root; }
  
  template <typename U>
  struct PreOrderIterator
  {
    Node<U>* current;

    explicit PreOrderIterator(Node<U>* current)
      : current(current)
    {
    }

    bool operator!=(const PreOrderIterator<U>& other)
    {
      return current != other.current;
    }

    // jzyk C++ (w odrnieniu od C#) nie obsuguje kontynuacji
    PreOrderIterator<U>& operator++() 
    {
      if (current->right)
      {
        current = current->right;
        while (current->left)
          current = current->left;
      }
      else
      {
        Node<T>* p = current->parent;
        while (p && current == p->right)
        {
          current = p;
          p = p->parent;
        }
        current = p;
      }
      return *this;
    }

    Node<U>& operator*() { return *current; }
  };

  typedef PreOrderIterator<T> iterator;

  iterator end()
  {
    return iterator{ nullptr };
  }

  iterator begin()
  {
    Node<T>* n = root;

    if (n)
      while (n->left)
        n = n->left;
    return iterator{ n };
  }

  // uwidocznij jako obiekt przegldania
  // do zrobienia: przekszta to na przegldanie wsteczne
  class pre_order_traversal
  {
    BinaryTree<T>& tree;
  public:
    pre_order_traversal(BinaryTree<T>& tree) : tree{tree} {}
    iterator begin() { return tree.begin(); }
    iterator end() { return tree.end(); }
  } pre_order;

  // do zrobienia: iterator przegldania wstecznego korzystajcy z rekurencyjnych koprocedur

  experimental::generator<Node<T>*> post_order()
  {
    return post_order_impl(root);
  }

private:
  // moesz uy te typu recursive_generator
  experimental::generator<Node<T>*> post_order_impl(Node<T>* node)
  {
    if (node)
    {
      for (auto x : post_order_impl(node->left))
        co_yield x;
      for (auto y : post_order_impl(node->right))
        co_yield y;
      co_yield node;
    }
  }
};

void std_iterators()
{
  vector<string> names{ "Jan", "Janina", "Julia", "Jacek" };

  vector<string>::iterator it = names.begin(); // albo begin(names)
  cout << "imi to " << *it << "\n";

  ++it; // przesu dalej iterator
  it->append(string(" Szymkowiak"));
  cout << "imi i nazwisko to " << *it << "\n";

  while (++it != names.end())
  {
    cout << "kolejne imi: " << *it << "\n";
  }

  // przegldanie caego wektora od koca
  // zwr uwag, e funkcje rbegin/rend s globalne i wystpuje operator ++, a nie --
  // rozwi tutaj sowo kluczowe auto do nazwy typu
  for (auto ri = rbegin(names); ri != rend(names); ++ri)
  {
    cout << *ri;
    if (ri + 1 != rend(names)) // arytmetyka iteratorw
      cout << ", ";
  }
  cout << endl;

  // stae iteratory
  vector<string>::const_reverse_iterator jacek = crbegin(names);
  // nie bdzie dziaao
  //*jacek += "Soplica";

  for (auto& name : names)
    cout << "name = " << name << "\n";
}

// przegldanie poprzeczne
void binary_tree_iterator()
{
  //         ja
  //        /  \
  //    matka   ojciec
  //      / \
  //   m.m.  o.m.

  BinaryTree<string> family{
    new Node<string>{"ja",
      new Node<string>{"matka",
        new Node<string>{"matka matki"},
        new Node<string>{"ojciec matki"}
      },
      new Node<string>{"ojciec"}
    }
  };

  // przegldanie wzdune
  for (auto it = family.begin(); it != family.end(); ++it)
  {
    cout << (*it).value << "\n";
  }

  cout << "=== a teraz poprzez dedykowany obiekt:\n";

  // uycie nazwy iteratora
  for (const auto& it: family.pre_order)
  {
    cout << it.value << "\n";
  }

  cout << "=== przegldanie wsteczne z koprocedurami:\n";

  // uycie koprocedur (zwraca wskaniki!)
  // przegldanie wsteczne: m.m. o.m. m. o. ja
  for (auto it: family.post_order())
  {
    cout << it->value << endl;
  }
}


int main()
{
  //std_iterators();
  binary_tree_iterator();

  getchar();
  return 0;
}
