using System.Collections.Generic;
using Unity.Services.Core.Internal;

namespace Unity.Services.Core.Telemetry.Internal
{
    /// <summary>
    /// Component to get or create the proper <see cref="IDiagnostics"/> for a given package.
    /// </summary>
    public interface IDiagnosticsFactory : IServiceComponent
    {
        /// <summary>
        /// All tags shared among all diagnostics events generated by <see cref="IDiagnostics"/> created by this factory.
        /// </summary>
        IReadOnlyDictionary<string, string> CommonTags { get; }

        /// <summary>
        /// Create a <see cref="IDiagnostics"/> setup with common tags for the given <paramref name="packageName"/>.
        /// </summary>
        /// <param name="packageName">
        /// The name of the package that will use the created <see cref="IDiagnostics"/> to send diagnostic events.
        /// Example value: "com.unity.services.core"
        /// </param>
        /// <returns>
        /// Return a <see cref="IDiagnostics"/> setup with common tags for the given <paramref name="packageName"/>.
        /// </returns>
        IDiagnostics Create(string packageName);
    }
}
