using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LearningCurve : MonoBehaviour
{
    private int CurrentAge = 30;
    public int AddedAge = 1;

    public float Pi = 3.14f;
    public string firstName = "Harrison";
    public bool IsAuthor = true;

    public int CurrentGold = 32;

    public bool PureOfHeart = true;
    public bool HasSecretIncantation = false;
    public string RareItem = "Reliktowy kamień";

    public string CharacterAction = "Atak";

    public int DiceRoll = 7;
    public int PlayerLives = 3;

    public Transform CamTransform;
    public GameObject directionLight;
    public Transform LightTransform;

    // Metoda Start jest wywoływana przed pierwszą aktualizacją ramki
    void Start()
    {
        Debug.Log(30 + 1);
        Debug.Log(CurrentAge + 1);

        ComputeAge();
        Debug.Log($"W ciągu znaków można bezpośrednio wstawiać zmienne, takie jak {FirstName}!");

        int CharacterLevel = 32;
        int NextSkillLevel = GenerateCharacter("Spike", CharacterLevel);
        Debug.Log(NextSkillLevel);
        Debug.Log(GenerateCharacter("Faye", CharacterLevel));

        Thievery();
        OpenTreasureChamber();
        PrintCharacterAction();
        RollDice();
        FindPartyMember();

        Dictionary<string, int> ItemInventory = new Dictionary<string, int>()
        {
            { "Eliksir", 5},
            { "Antidotum", 7},
            { "Aspiryna", 1}
        };

        Debug.LogFormat("Pozycji: {0}", ItemInventory.Count);

        HealthStatus();

        Character hero = new Character();
        Character villain= hero;
        villain.name = "Kane – żelazna ręka";
        hero.PrintStatsInfo();
        villain.PrintStatsInfo();

        Character heroine = new Character("Agata");
        heroine.PrintStatsInfo();

        Weapon huntingBow = new Weapon("Łuk na polowanie", 105);
        Weapon warBow = huntingBow;
        warBow.name = "Łuk wojenny";
        warBow.damage = 155;
        huntingBow.PrintWeaponStats();
        warBow.PrintWeaponStats();

        Paladin knight = new Paladin("Sir Arthur", huntingBow);
        knight.PrintStatsInfo();

        CamTransform = this.GetComponent<Transform>();
        Debug.Log(CamTransform.localPosition);

        //directionLight = GameObject.Find("Directional Light");
        LightTransform = DirectionLight.GetComponent<Transform>();
        Debug.Log(lightTransform.localPosition);
    }

    /// <summary>
    /// Metoda sumowania dwóch zmiennych 
    /// </summary>
    void ComputeAge()
    {
        Debug.Log(CurrentAge + AddedAge);
    }

    public int GenerateCharacter(string name, int level)
    {
        return level += 5;
    }

    public void Thievery()
    {
        if (CurrentGold > 50)
        {
            Debug.Log("Jesteś bogaczem!");
        }
        else if (CurrentGold < 15)
        {
            Debug.Log("Nie ma tu za bardzo co kraść... ");
        }
        else
        {
            Debug.Log("Wygląda na to, że masz w portfelu dokładnie tyle, ile trzeba.");
        }
    }

    public void OpenTreasureChamber()
    {
        if (PureOfHeart && RareItem == "Reliktowy kamień")
        {
            if (!HasSecretIncantation)
            {
                Debug.Log("Masz ducha, ale nie masz wiedzy.");
            }
            else
            {
                Debug.Log("Skarb jest Twój. Jesteś bohaterem!");
            }
        }
        else
        {
            Debug.Log("Wróć, kiedy będziesz mieć to, co jest potrzebne.");
        }
    }

    public void PrintCharacterAction()
    {
        switch (CharacterAction)
        {
            case "Regeneracja":
                Debug.Log("Wysłano eliksir.");
                break;
            case "Atak":
                Debug.Log("Do broni!");
                break;
            default:
                Debug.Log("Tarcze w górę.");
                break;
        }
    }

    public void RollDice()
    {
        switch(DiceRoll)
        {
            case 7:
            case 15:
                Debug.Log("Uszkodzenia przeciętne. Nie jest źle. ");
                break;
            case 20:
                Debug.Log("Dokładne trafienie. Nieprzyjaciel zniszczony! ");
                break;
            default:
                Debug.Log("Nie trafiłeś w cel i upadłeś na twarz. ");
                break;
        }
    }

    public void FindPartyMember()
    {
        List<string> QuestPartyMembers = new List<string>()
        {
            "Barbarzyńca Grim",
            "Mędrzec Merlin",
            "Rycerz Sterling"
        };
        int listLength = QuestPartyMembers.Count; 

        QuestPartyMembers.Add("Nekromanta Craven");
        QuestPartyMembers.Insert(1, "Złodziej Tanis");
        QuestPartyMembers.RemoveAt(0);
        //QuestPartyMembers.Remove("Barbarzyńca Grim");

        Debug.LogFormat("Uczestników: {0}", listLength);

        for (int i = 0; i < listLength; i++)
        {
            Debug.LogFormat("Indeks: {0} - {1}", i, QuestPartyMembers[i]);

            if (QuestPartyMembers[i] == "Mędrzec Merlin")
            {
                Debug.Log("Cieszę się, że tu jesteś Merlinie!");
            }
        }
    }

    public void HealthStatus()
    {
        while (PlayerLives > 0)
        {
            Debug.Log("Nadal żyjesz!");
            PlayerLives--;
        }

        Debug.Log("Gracz zakończył życie...");
    }
}
