/*---------------------------------------------------------------------------*/
    static void sec_print(bfd *b, asection *section, PTR jnk){
        unsigned char *buf;
        int i, j, size;

        printf( "%d %s\n",                 section->index, section->name );
        printf( "\tZnaczniki 0x%08X",          section->flags );
        printf( "\tWyrwnanie: 2^%d\n",     section->alignment_power );
        printf( "\tAdres wirtualny: 0x%X", section->vma );
        printf( "\tAdres adowania: 0x%X\n",  section->lma );
        printf( "\tRozmiar wyjciowy: %4d",      section->_cooked_size );
        printf( "\tRozmiar wejciowy: %d\n",      section->_raw_size );

        size = section->_cooked_size;
        buf = calloc( size, 1 );
        if ( bfd_get_section_contents( b, section, buf, 0, size ) ) {
            printf("\n\tZawarto:\n");
            for ( i = 0; i < size; i +=16 ) {
                printf( "\t" );
                for (j = 0; j < 16 && j+i < size; j++ ) /* ptla liczb szesnastkowych */
                    printf("%02X ", buf[i+j] );
            
                for ( ; j < 16; j++ )             /* ptla dopeniajca */ 
                    printf("   ");

                for (j = 0; j < 16 && j+i < size; j++) /* ptla ASCII */
                    printf("%c", isprint(buf[i+j])? buf[i+j] : '.');
                
                printf("\n");
            }
            printf("\n\n");
        }

        return;
    }

    int main( int argc, char **argv ) {
        /*     ... te wiersza maj znajdowa si przed funkcj bfd_close( )   */
        bfd_map_over_sections( b, sec_print, NULL );
        /*     ...     */
    }
/*-----------------------------------------------------------------------*/
