/*---------------------------------------------------------------------------*/
    /* osona funkcji ptrace: kompilacja - `gcc -c new_ptrace.c`
                              zaadowanie - `insmod -f new_ptrace.o`
                              odadowanie - `rmmod new_ptrace`        */
    #define __KERNEL_ _
    #define MODULE
    #define LINUX

    #include <linux/kernel.h>  /* wymagany */
    #include <linux/module.h>  /* wymagany */
    #include <linux/init.h>    /* wymagany */
    #include <linux/unistd.h>  /* tabela wywoa systemowych */
    #include <linux/sched.h>   /* struktura zadania task, current( ) */
    #include <linux/ptrace.h>  /* typy ptrace */


    asmlinkage int (*old_ptrace)(long req, long pid, long addr, long data);

    extern long sys_call_table[];

    asmlinkage int new_ptrace(long req, long pid, long addr, long data){
        /* jeeli wywoujcy jest ledzony funkcj ptarce: */
           if ( current->ptrace & PT_PTRACED ) {
              if ( req == PTRACE_TRACEME ||
                        req == PTRACE_ATTACH  ||
                        req == PTRACE_DETACH  ||
                 req == PTRACE_CONT      )
                /* okam go i powiedz, e wszystko jest w porzdku */
                    return(0); 

              /* powiadom uytkownika, e wykryto inn funkcj ptrace */
              print("Prevented pid %d (%s) from ptrace(%ld) on %ld\n",
                       current->pid, current->comm, request, pid );
              return(-EIO); /* zwracana warto standardowej funkcji ptrace( ) */
           }

           return((*old_ptrace)(req, pid, addr, data));
    }

    int _ _init init_new_ptrace(void){
           EXPORT_NO_SYMBOLS;
        /* zachowaj zapis wywoania systemowego starej funkcji ptrace i zastp go naszym */
           old_ptrace = (int(*)(long request, long pid, long addr, 
                long data))   (sys_call_table[_ _NR_ptrace]);
           sys_call_table[_ _NR_ptrace] = (unsigned long) new_ptrace;
           return(0);
    }

    void _ _exit exit_new_ptrace(void){
        /* odtwrz zapis oryginalnego wywoania funkcji w tabeli wywoa */
           if ( sys_call_table[_ _NR_ptrace] != (unsigned long) new_ptrace )
              print("Ostrzeenie: kto przej po nas ptrace( ). "
                 "Powracamy.\n");
           sys_call_table[_ _NR_ptrace] = (unsigned long) old_ptrace;
           return;
    }

    module_init(init_new_ptrace);        /* eksport procedury init */
    module_exit(exit_new_ptrace);        /* eksport procedury init exit */
/*-----------------------------------------------------------------------*/
