#------------------------------------------------------------------------------
# insn_xref.pl -- generuje odwoania dla danych uzyskanych z programu int_code.pl
# UWAGA: zmienia format pliku na
# INSN|addr|name|size|bytes|mem|mtyp|src|styp|dest|dtype|arg|atyp|xrefs

my %xrefs;    # dodanie zmiennej globalnej

# nowa wersja ptli while (insn) 
$insn = $head;
while ( $insn ) {
     gen_xrefs( $insn, $$insn{src}, $$insn{stype} );
     gen_xrefs( $insn, $$insn{dest}, $$insn{dtype} );
     gen_xrefs( $insn, $$insn{arg}, $$insn{atype} );
     $insn = $$insn{next};
}

# ptla wyjcia
$insn = $head;
while ( $insn ) {
    if ( $xrefs{$$insn{addr}} ) {
        chop $xrefs{$$insn{addr}};    # usunicie kocowego ukonika
    }
    print "INSN|";                    # wywietlenia rodzaju wiersza
    print "$$insn{addr}|$$insn{name}|$$insn{size}|$$insn{bytes}|";
    print "$$insn{mnem}|$$insn{mtype}|$$insn{src}|$$insn{stype}|";
    print "$$insn{dest}|$$insn{dtype}|$$insn{arg}|$$insn{atype}|";
    print "$xrefs{$$insn{addr}}\n";
    $insn = $$insn{next};
}

sub gen_xrefs {
    local($i, $op, $op_type) = @_;
    local $addr;
    if ( $op_type eq "OP_ADDR" && $op =~ /0[xX]([0-9a-fA-F]+)/ ) {
        $addr = $1;
        $xrefs{$addr} .= "$$i{addr}:";
    }
    return;
}
#--------------------------------------------------------------------------
