﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Net.Mail;
using System.Diagnostics.Eventing.Reader;
using System.Net;
using Homefield.Sentinel;

namespace HomefieldSentinel
{
    class TheSentinel
    {
        SmtpClient smtpClient;
        EventLogWatcher logWatcher;
        Logger log;

        // Kwerendowanie dziennika zdarzeń, aby pobrać zdarzenie o id 4656 (listy ACL inspekcji)
        EventLogQuery logQuery =
                new EventLogQuery("Security", PathType.LogName,
                                              "*[System/EventID=4656]");
        public void StartWatching()
        {
            try
            {
                // Ostateczna lokalizacja to \windows\syswow64\sentinel.log
                log = new Logger("sentinel.log");
                log.WriteLine("Uruchamianie...");

                this.smtpClient = new SmtpClient(
                                         "smtp-mail.outlook.com", 587);
                this.logWatcher = new EventLogWatcher(logQuery);
                this.logWatcher.EventRecordWritten +=
                                this.logWatcher_EventRecordWritten;
                this.logWatcher.Enabled = true;
                this.smtpClient.EnableSsl = true;

                // Projekt z Githuba szyfruje poświadczenia     
                this.smtpClient.Credentials = new NetworkCredential(
                                                   "<twój_e-mail>", "<twoje_hasło>");
                // Wersja ze strony https://github.com/wunderwuzzi23/Sentinel
                // pokazuje, jak użyć pliku konfiguracyjnego i szyfrowanych poświadczeń

                log.WriteLine("Uruchomiono.");
            }
            catch (Exception e)
            {
                log.WriteLine(
                      " Błąd w trakcie uruchamiania: " + e.ToString());
            }
        }

        /// Procedura obsługi zdarzeń dla obiektu watcher
        /// Sprawdzanie identyfikatora zdarzeń, żeby zweryfikować, czy dostęp
        /// jest związany z plikiem passwords.txt, który skonfigurowaliśmy
        private void logWatcher_EventRecordWritten(object sender,
                               EventRecordWrittenEventArgs e)
        {
            if (e.EventRecord.Id == 4656)
            {
                // Czy to jest dla pliku, który nas interesuje?
                if (e.EventRecord.FormatDescription().Contains("passwords.txt"))
                {
                    try
                    {
                        log.WriteLine("Uzyskano dostęp do pliku honeypota");
                        log.WriteLine(e.EventRecord.FormatDescription());
                        log.WriteLine("****************************************");

                        // Wysyłamy e-mail
                        string email =
                          ((NetworkCredential)this.smtpClient.Credentials).UserName;
                        MailMessage mail = new MailMessage(email, email);
                        mail.Subject =
                              "[Powiadomienie Strażnika] Uzyskano dostęp do pliku Honeypota.";
                        mail.Body = e.EventRecord.FormatDescription();
                        mail.Priority = MailPriority.High;
                        mail.IsBodyHtml = false;
                        smtpClient.Send(mail);
                    }
                    catch (Exception ex)
                    {
                        log.WriteLine(
                             "Błąd OnEventWritten: " + ex.ToString());
                    }
                }
            }
        }
        public void StopWatching()
        {
            this.logWatcher.Enabled = false;
            log.WriteLine("Zatrzymano.");
        }
    }

}
