﻿// ZAKRĘĆ KOŁEM
// Rozdział 4. (Warianty list)
// Struktury danych i algorytmy w języku C#, wydanie drugie

CircularLinkedList<string> categories = new();
categories.AddLast("Sport");
categories.AddLast("Kultura");
categories.AddLast("Historia");
categories.AddLast("Geografia");
categories.AddLast("Ludzie");
categories.AddLast("Technika");
categories.AddLast("Przyroda");
categories.AddLast("Nauka");

bool isStopped = true;
Random random = new();
DateTime targetTime = DateTime.Now;
int ms = 0;
foreach (string category in categories)
{
    if (isStopped)
    {
        Console.WriteLine("Naciśnij klawisz [Enter], aby zacząć. ");
        ConsoleKey key = Console.ReadKey().Key;
        if (key == ConsoleKey.Enter)
        {
            ms = random.Next(1000, 5000);
            targetTime = DateTime.Now.AddMilliseconds(ms);
            isStopped = false;
            Console.WriteLine(category);
        }
        else { return; }
    }
    else
    {
        int remaining = (int)(targetTime - DateTime.Now).TotalMilliseconds;
        int waiting = Math.Max(100, (ms - remaining) / 5);
        await Task.Delay(waiting);

        if (DateTime.Now >= targetTime)
        {
            Console.ForegroundColor = ConsoleColor.Red;
            isStopped = true;
        }

        Console.WriteLine(category);
        Console.ResetColor();
    }
}
