﻿// PRODUCT LOCATION
// Rozdział 6 (Słowniki i zbiory)
// Struktury danych i algorytmy w C#, wydanie II

Dictionary<string, string> products = new()
{
    { "5901020304050", "A1" },
    { "5910203040506", "B5" },
    { "5920304050607", "C9" }
};
products["5930405060708"] = "D7";

string key = "5940506070809";
if (!products.ContainsKey(key))
{
    products.Add(key, "A3");
}

if (!products.TryAdd(key, "B4"))
{
    Console.WriteLine("Nie można dodać.");
}

Console.WriteLine("Wszystkie produkty:");
if (products.Count == 0) { Console.WriteLine("Pusto"); }
foreach ((string k, string v) in products)
{
    Console.WriteLine($"{k}: {v}");
}

Console.Write("\nSzukaj po kodzie kreskowym: ");
string barcode = Console.ReadLine() ?? string.Empty;
if (products.TryGetValue(barcode, out string? location))
{
    Console.WriteLine($"Produkt znajduje się w obszarze {location}.");
}
else
{
    Console.WriteLine("Produkt nie istnieje.");
}
